/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.event;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.squashtest.tm.domain.event.RequirementAuditEventVisitor;
import org.squashtest.tm.domain.requirement.RequirementVersion;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
public abstract class RequirementAuditEvent {
    @Id
    @Column(name="EVENT_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="requirement_audit_event_event_id_seq")
    @SequenceGenerator(name="requirement_audit_event_event_id_seq", sequenceName="requirement_audit_event_event_id_seq", allocationSize=1)
    private Long id;
    @ManyToOne
    @JoinColumn(name="REQ_VERSION_ID")
    @NotNull
    private RequirementVersion requirementVersion;
    @Temporal(value=TemporalType.TIMESTAMP)
    @NotNull
    @Column(name="EVENT_DATE")
    private Date date;
    @NotNull
    @Size(max=255)
    private @NotNull @Size(max=255) String author;

    public RequirementAuditEvent() {
    }

    public RequirementAuditEvent(RequirementVersion requirementVersion, String author) {
        this.requirementVersion = requirementVersion;
        this.author = author;
        this.date = new Date();
    }

    public Long getId() {
        return this.id;
    }

    public RequirementVersion getRequirementVersion() {
        return this.requirementVersion;
    }

    public Date getDate() {
        return this.date;
    }

    public String getAuthor() {
        return this.author;
    }

    public abstract void accept(RequirementAuditEventVisitor var1);
}

