/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.customfield;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.persistence.CollectionTable;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.OrderColumn;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldOption;
import org.squashtest.tm.domain.customfield.CustomFieldVisitor;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.exception.WrongStringSizeException;
import org.squashtest.tm.exception.customfield.CannotDeleteDefaultOptionException;
import org.squashtest.tm.exception.customfield.CodeAlreadyExistsException;
import org.squashtest.tm.exception.customfield.CodeDoesNotMatchesPatternException;
import org.squashtest.tm.exception.customfield.OptionAlreadyExistException;

@Entity
@DiscriminatorValue(value="SSF")
public class SingleSelectField
extends CustomField {
    @ElementCollection
    @CollectionTable(name="CUSTOM_FIELD_OPTION", joinColumns={@JoinColumn(name="CF_ID")})
    @OrderColumn(name="POSITION")
    @Valid
    private List<CustomFieldOption> options = new ArrayList<CustomFieldOption>();

    public SingleSelectField() {
        super(InputType.DROPDOWN_LIST);
    }

    public void addOption(CustomFieldOption option) {
        this.checkLabelAvailable(option.getLabel());
        this.checkCodeAvailable(option.getCode());
        this.checkCodeMatchesPattern(option.getCode());
        this.options.add(option);
    }

    private void checkCodeMatchesPattern(String code) {
        if (!code.matches("^[A-Za-z0-9_^;]*$")) {
            throw new CodeDoesNotMatchesPatternException(code, "^[A-Za-z0-9_^;]*$", "optionCode");
        }
        if (code.length() > 30 || code.length() < 1) {
            throw new WrongStringSizeException("code", 1, 30);
        }
    }

    private void checkCodeAvailable(String code) {
        if (!this.isCodeAvailable(code)) {
            throw new CodeAlreadyExistsException(null, code, CustomFieldOption.class);
        }
    }

    private void checkLabelAvailable(String label) {
        if (label.length() > 255 || label.length() < 1) {
            throw new WrongStringSizeException("label", 1, 255);
        }
        if (!this.isLabelAvailable(label)) {
            throw new OptionAlreadyExistException(label);
        }
    }

    public void removeOption(@NotBlank String label) {
        if (this.defaultValue != null && this.defaultValue.equals(label)) {
            throw new CannotDeleteDefaultOptionException(label);
        }
        this.removeOptionWithoutCheck(label);
    }

    private void removeOptionWithoutCheck(@NotBlank String label) {
        Iterator<CustomFieldOption> it = this.options.iterator();
        while (it.hasNext()) {
            if (!label.equals(it.next().getLabel())) continue;
            it.remove();
            return;
        }
    }

    public void changeOptionLabel(String previousLabel, String newlabel) {
        this.checkLabelAvailable(newlabel);
        int index = this.findIndexOfLabel(previousLabel);
        String code = this.findCodeOf(previousLabel);
        String colour = this.findColourOf(previousLabel);
        if (this.defaultValue.equals(previousLabel)) {
            this.defaultValue = newlabel;
        }
        this.removeOption(previousLabel);
        this.addOption(newlabel, code, colour, index);
    }

    public void changeOptionCode(String optionLabel, String newCode) {
        this.checkCodeAvailable(newCode);
        this.checkCodeMatchesPattern(newCode);
        int index = this.findIndexOfLabel(optionLabel);
        String colour = this.findColourOf(optionLabel);
        this.removeOptionWithoutCheck(optionLabel);
        this.addOption(optionLabel, newCode, colour, index);
    }

    public void changeOptionColour(String optionLabel, String newColour) {
        int index = this.findIndexOfLabel(optionLabel);
        String code = this.findCodeOf(optionLabel);
        this.removeOptionWithoutCheck(optionLabel);
        this.addOption(optionLabel, code, newColour, index);
    }

    private String findCodeOf(String previousLabel) {
        for (CustomFieldOption option : this.options) {
            if (!previousLabel.equals(option.getLabel())) continue;
            return option.getCode();
        }
        return null;
    }

    public String findColourOf(String previousLabel) {
        for (CustomFieldOption option : this.options) {
            if (!previousLabel.equals(option.getLabel())) continue;
            return option.getColour();
        }
        return null;
    }

    public String findColourOfByCode(String code) {
        for (CustomFieldOption option : this.options) {
            if (!code.equals(option.getCode())) continue;
            return option.getColour();
        }
        return null;
    }

    private boolean isLabelAvailable(String newlabel) {
        return this.findIndexOfLabel(newlabel) == -1;
    }

    private boolean isCodeAvailable(String newCode) {
        return this.findIndexOfCode(newCode) == -1;
    }

    private int findIndexOfCode(String newCode) {
        for (CustomFieldOption option : this.options) {
            if (!newCode.equals(option.getCode())) continue;
            return this.options.indexOf(option);
        }
        return -1;
    }

    private void addOption(String newlabel, String code, String colour, int index) {
        this.options.add(index, new CustomFieldOption(newlabel, code, colour));
    }

    private int findIndexOfLabel(String previousLabel) {
        for (CustomFieldOption option : this.options) {
            if (!previousLabel.equals(option.getLabel())) continue;
            return this.options.indexOf(option);
        }
        return -1;
    }

    public List<CustomFieldOption> getOptions() {
        return Collections.unmodifiableList(this.options);
    }

    public void moveOptions(int newIndex, List<String> optionsLabels) {
        List<CustomFieldOption> newOptions = this.copyOptionList(optionsLabels);
        this.removeOptionsWithoutCheck(optionsLabels);
        this.options.addAll(newIndex, newOptions);
    }

    private List<CustomFieldOption> copyOptionList(List<String> optionsLabels) {
        ArrayList<CustomFieldOption> newOptions = new ArrayList<CustomFieldOption>(optionsLabels.size());
        for (String optionLabel : optionsLabels) {
            String code = this.findCodeOf(optionLabel);
            String colour = this.findColourOf(optionLabel);
            newOptions.add(new CustomFieldOption(optionLabel, code, colour));
        }
        return newOptions;
    }

    private void removeOptionsWithoutCheck(List<String> optionsLabels) {
        for (String option : optionsLabels) {
            this.removeOptionWithoutCheck(option);
        }
    }

    @Override
    public void accept(CustomFieldVisitor visitor) {
        visitor.visit(this);
    }
}

