/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.customfield;

import java.math.BigDecimal;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldVisitor;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.exception.customfield.WrongCufNumericFormatException;

@Entity
@DiscriminatorValue(value="NUM")
public class NumericField
extends CustomField {
    private BigDecimal numericDefaultValue;

    public NumericField() {
        super(InputType.NUMERIC);
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        if (StringUtils.isBlank((CharSequence)defaultValue)) {
            this.defaultValue = defaultValue;
            this.numericDefaultValue = null;
        } else {
            try {
                String formattedDefaultValue = defaultValue.replace(",", ".");
                this.numericDefaultValue = new BigDecimal(formattedDefaultValue);
                this.defaultValue = this.numericDefaultValue.toString();
            }
            catch (NumberFormatException nfe) {
                throw new WrongCufNumericFormatException(nfe);
            }
        }
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue != null ? this.defaultValue : "";
    }

    @Override
    public void accept(CustomFieldVisitor visitor) {
        visitor.visit(this);
    }
}

