/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.customfield;

import javax.persistence.Embeddable;
import javax.persistence.MappedSuperclass;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.util.DigestUtils;

@Embeddable
@MappedSuperclass
public class DenormalizedCustomFieldOption {
    @NotBlank
    @Size(max=255)
    private @NotBlank @Size(max=255) String label;
    @NotBlank
    @Size(max=30)
    @Pattern(regexp="^[A-Za-z0-9_^;]*$", message="{org.squashtest.tm.validation.constraint.onlyStdChars}")
    private @NotBlank @Size(max=30) @Pattern(regexp="^[A-Za-z0-9_^;]*$", message="{org.squashtest.tm.validation.constraint.onlyStdChars}") String code = "";

    public DenormalizedCustomFieldOption(String label, String code) {
        this.label = label;
        this.code = code;
    }

    public DenormalizedCustomFieldOption(String label) {
        String generatedCode = DigestUtils.md5DigestAsHex((byte[])label.getBytes());
        this.label = label;
        this.code = generatedCode.substring(0, 30);
    }

    protected DenormalizedCustomFieldOption() {
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label.trim();
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public int hashCode() {
        int result = 53;
        result = 57 * result + (this.label == null ? 0 : this.label.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DenormalizedCustomFieldOption)) {
            return false;
        }
        DenormalizedCustomFieldOption other = (DenormalizedCustomFieldOption)obj;
        return !(this.label == null ? other.label != null : !this.label.equals(other.label));
    }
}

