/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.customfield;

import java.text.ParseException;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.core.foundation.lang.DateUtils;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldBinding;
import org.squashtest.tm.domain.customfield.CustomFieldValueVisitor;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.customfield.SingleValuedCustomFieldValue;
import org.squashtest.tm.exception.customfield.BindableEntityMismatchException;
import org.squashtest.tm.exception.customfield.MandatoryCufException;
import org.squashtest.tm.exception.customfield.WrongCufDateFormatException;

@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="FIELD_TYPE", discriminatorType=DiscriminatorType.STRING)
@DiscriminatorValue(value="CF")
public class CustomFieldValue
implements Identified,
SingleValuedCustomFieldValue {
    public static final int MAX_SIZE = 255;
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomFieldValue.class);
    protected Long boundEntityId;
    @Id
    @Column(name="CFV_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="custom_field_value_cfv_id_seq")
    @SequenceGenerator(name="custom_field_value_cfv_id_seq", sequenceName="custom_field_value_cfv_id_seq", allocationSize=1)
    private Long id;
    @Enumerated(value=EnumType.STRING)
    protected BindableEntity boundEntityType;
    @ManyToOne(cascade={CascadeType.DETACH})
    @JoinColumn(name="CFB_ID")
    protected CustomFieldBinding binding;
    @Size(min=0, max=255)
    protected @Size(min=0, max=255) String value;
    @Column(name="CF_ID")
    protected Long cufId;

    public CustomFieldValue() {
    }

    public CustomFieldValue(Long boundEntityId, BindableEntity boundEntityType, CustomFieldBinding binding, String value) {
        this.boundEntityId = boundEntityId;
        this.binding = binding;
        this.cufId = binding.getCustomField().getId();
        this.doSetBoundEntityType(boundEntityType);
        this.doSetValue(value);
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.doSetValue(value);
    }

    private void doSetValue(String value) {
        CustomField cuf = this.doGetCustomField();
        if (cuf != null) {
            if (!cuf.isOptional() && StringUtils.isBlank((CharSequence)value)) {
                throw new MandatoryCufException(this);
            }
            if (cuf.inputType == InputType.DATE_PICKER && !StringUtils.isBlank((CharSequence)value)) {
                try {
                    DateUtils.parseIso8601Date((String)value);
                }
                catch (ParseException pe) {
                    throw new WrongCufDateFormatException(pe);
                }
            }
        }
        this.value = value;
    }

    public CustomFieldBinding getBinding() {
        return this.binding;
    }

    public void setBinding(CustomFieldBinding binding) {
        this.binding = binding;
    }

    public CustomField getCustomField() {
        return this.doGetCustomField();
    }

    private CustomField doGetCustomField() {
        if (this.binding != null) {
            return this.binding.getCustomField();
        }
        return null;
    }

    public Long getBoundEntityId() {
        return this.boundEntityId;
    }

    public Long getCufId() {
        return this.cufId;
    }

    public void setCufId(Long cufId) {
        this.cufId = cufId;
    }

    public BindableEntity getBoundEntityType() {
        return this.boundEntityType;
    }

    public void setBoundEntity(BoundEntity entity) {
        this.boundEntityId = entity.getBoundEntityId();
        this.doSetBoundEntityType(entity.getBoundEntityType());
    }

    private void doSetBoundEntityType(BindableEntity entityType) {
        if (entityType != this.binding.getBoundEntity()) {
            throw new BindableEntityMismatchException("attempted to bind '" + (Object)((Object)entityType) + "' while expected '" + (Object)((Object)this.binding.getBoundEntity()) + "'");
        }
        this.boundEntityType = entityType;
    }

    public CustomFieldValue copy() {
        CustomFieldValue copy = new CustomFieldValue();
        copy.setBinding(this.binding);
        copy.setValue(this.value);
        copy.setCufId(this.getCufId());
        return copy;
    }

    public boolean representsSameBinding(CustomFieldValue otherValue) {
        return otherValue.getBinding().getId().equals(this.binding.getId());
    }

    public boolean representsSameCustomField(CustomFieldValue otherValue) {
        return otherValue.getCustomField().getId().equals(this.getCustomField().getId());
    }

    public Date getValueAsDate() {
        if (this.getCustomField() != null && this.getCustomField().getInputType() == InputType.DATE_PICKER) {
            try {
                return DateUtils.parseIso8601Date((String)this.value);
            }
            catch (ParseException e) {
                LOGGER.warn("Unable to parse date '" + this.value + "' of custom field value #" + this.id, (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public RawValue asRawValue() {
        return new RawValue(this.value);
    }

    public void accept(CustomFieldValueVisitor visitor) {
        visitor.visit(this);
    }
}

