/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.campaign;

import org.squashtest.tm.core.foundation.i18n.Internationalizable;
import org.squashtest.tm.domain.campaign.TestPlanStatistics;

public enum TestPlanStatus implements Internationalizable
{
    DONE,
    READY,
    RUNNING;

    private static final String I18N_KEY_ROOT = "label.testPlanStatus.";

    public static TestPlanStatus getStatus(TestPlanStatistics statistics) {
        if (TestPlanStatus.allReady(statistics)) {
            return READY;
        }
        if (TestPlanStatus.allDone(statistics)) {
            return DONE;
        }
        return RUNNING;
    }

    private static boolean allReady(TestPlanStatistics statistics) {
        return statistics.getNbReady() == statistics.getNbTestCases();
    }

    private static boolean allDone(TestPlanStatistics statistics) {
        return statistics.getNbDone() == statistics.getNbTestCases();
    }

    public String getI18nKey() {
        return I18N_KEY_ROOT + this.name();
    }
}

