/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.campaign;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.SequenceGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.hibernate.annotations.Persister;
import org.springframework.context.MessageSource;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.audit.Auditable;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.audit.AuditableMixinAspect;
import org.squashtest.tm.domain.audit.AuditableSupport;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.library.HasExecutionStatus;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testcase.CreateExecutionFromTestCaseVisitor;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseExecutionMode;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.exception.NotAutomatedException;
import org.squashtest.tm.exception.execution.TestPlanItemNotExecutableException;
import org.squashtest.tm.infrastructure.hibernate.IterationTestPlanItemPersister;
import org.squashtest.tm.security.annotation.InheritsAcls;

@NamedQueries(value={@NamedQuery(name="IterationTestPlanItem.findAllByIdsOrderedByIterationTestPlan", query="select tp from Iteration i join i.testPlans tp where tp.id in :testPlanIds order by index(tp)"), @NamedQuery(name="IterationTestPlanItem.findAllByIdsOrderedBySuiteTestPlan", query="select tp from TestSuite ts join ts.testPlan tp where ts.id = :suiteId and tp.id in :testPlanIds order by index(tp)"), @NamedQuery(name="IterationTestPlanItem.fetchForExecutionCreation", query="select distinct itpi from IterationTestPlanItem itpi inner join fetch itpi.referencedTestCase tc left join fetch itpi.referencedDataset ds left join fetch ds.parameterValues left join fetch tc.parameters left join fetch tc.automationRequest left join fetch tc.automatedTest left join fetch itpi.testSuites tsinner join fetch itpi.iteration it inner join fetch it.campaign left join fetch itpi.executions exec left join fetch exec.issueList left join fetch exec.automatedExecutionExtender where itpi.id in (:itemTestPlanIds)")})
@Entity
@Auditable
@InheritsAcls(constrainedClass=Iteration.class, collectionName="testPlans")
@Persister(impl=IterationTestPlanItemPersister.class)
public class IterationTestPlanItem
implements HasExecutionStatus,
Identified,
AuditableMixin {
    private static final Set<ExecutionStatus> LEGAL_EXEC_STATUS;
    @Id
    @Column(name="ITEM_TEST_PLAN_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="item_test_plan_item_test_plan_id_seq")
    @SequenceGenerator(name="item_test_plan_item_test_plan_id_seq", sequenceName="item_test_plan_item_test_plan_id_seq", allocationSize=1)
    private Long id;
    @Enumerated(value=EnumType.STRING)
    private ExecutionStatus executionStatus;
    private String label;
    @ManyToOne
    @JoinColumn(name="USER_ID")
    private User user;
    @Column(insertable=false)
    private String lastExecutedBy;
    @Column(insertable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastExecutedOn;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TCLN_ID", referencedColumnName="TCLN_ID")
    private TestCase referencedTestCase;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="DATASET_ID", referencedColumnName="DATASET_ID")
    private Dataset referencedDataset;
    @OrderColumn(name="EXECUTION_ORDER")
    @JoinTable(name="ITEM_TEST_PLAN_EXECUTION", joinColumns={@JoinColumn(name="ITEM_TEST_PLAN_ID")}, inverseJoinColumns={@JoinColumn(name="EXECUTION_ID")})
    @OneToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE, CascadeType.DETACH})
    private final List<Execution> executions;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinTable(name="ITEM_TEST_PLAN_LIST", joinColumns={@JoinColumn(name="ITEM_TEST_PLAN_ID", insertable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="ITERATION_ID", insertable=false, updatable=false)})
    private Iteration iteration;
    @ManyToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE}, mappedBy="testPlan")
    private List<TestSuite> testSuites;
    @Transient
    public AuditableSupport audit;

    static {
        HashSet<ExecutionStatus> set = new HashSet<ExecutionStatus>();
        set.add(ExecutionStatus.SUCCESS);
        set.add(ExecutionStatus.BLOCKED);
        set.add(ExecutionStatus.FAILURE);
        set.add(ExecutionStatus.RUNNING);
        set.add(ExecutionStatus.READY);
        set.add(ExecutionStatus.UNTESTABLE);
        set.add(ExecutionStatus.SETTLED);
        LEGAL_EXEC_STATUS = Collections.unmodifiableSet(set);
    }

    public IterationTestPlanItem() {
        AuditableMixinAspect.ajc$interFieldInit$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$audit(this);
        this.executionStatus = ExecutionStatus.READY;
        this.label = "";
        this.executions = new ArrayList<Execution>();
        this.testSuites = new ArrayList<TestSuite>();
    }

    public IterationTestPlanItem(TestCase testCase) {
        AuditableMixinAspect.ajc$interFieldInit$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$audit(this);
        this.executionStatus = ExecutionStatus.READY;
        this.label = "";
        this.executions = new ArrayList<Execution>();
        this.testSuites = new ArrayList<TestSuite>();
        this.referencedTestCase = testCase;
        this.referencedDataset = null;
        this.label = testCase.getName();
    }

    public IterationTestPlanItem(TestCase testCase, Dataset dataset) {
        AuditableMixinAspect.ajc$interFieldInit$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$audit(this);
        this.executionStatus = ExecutionStatus.READY;
        this.label = "";
        this.executions = new ArrayList<Execution>();
        this.testSuites = new ArrayList<TestSuite>();
        this.referencedTestCase = testCase;
        this.referencedDataset = dataset;
        this.label = testCase.getName();
    }

    public IterationTestPlanItem(TestCase testCase, Dataset dataset, User assignee) {
        this(testCase, dataset);
        this.user = assignee;
    }

    public Iteration getIteration() {
        return this.iteration;
    }

    @Override
    public ExecutionStatus getExecutionStatus() {
        return this.executionStatus;
    }

    @Override
    public Set<ExecutionStatus> getLegalStatusSet() {
        return LEGAL_EXEC_STATUS;
    }

    public void setExecutionStatus(ExecutionStatus executionStatus) {
        this.executionStatus = executionStatus;
    }

    public void updateExecutionStatus() {
        if (this.executions.isEmpty()) {
            this.executionStatus = ExecutionStatus.READY;
        } else {
            Execution execution = this.getLatestExecution();
            this.executionStatus = execution.getExecutionStatus();
        }
    }

    public TestCase getReferencedTestCase() {
        return this.referencedTestCase;
    }

    public void setReferencedTestCase(TestCase referencedTestCase) {
        this.referencedTestCase = referencedTestCase;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public List<Execution> getExecutions() {
        return this.executions;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLastExecutedBy() {
        return this.lastExecutedBy;
    }

    public void setLastExecutedBy(String lastExecutedBy) {
        this.lastExecutedBy = lastExecutedBy;
    }

    public Date getLastExecutedOn() {
        return this.lastExecutedOn;
    }

    public void setLastExecutedOn(Date lastExecutedOn) {
        this.lastExecutedOn = lastExecutedOn;
        if (this.getIteration() != null) {
            this.getIteration().updateAutoDates(lastExecutedOn);
        }
    }

    public void emptyExecutions() {
        this.executions.clear();
    }

    public void addExecution(@NotNull Execution execution) {
        Execution execution2 = execution;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)execution2);
        this.executions.add(execution);
        execution.notifyAddedTo(this);
        this.updateExecutionStatus();
        this.lastExecutedBy = null;
        this.lastExecutedOn = null;
        this.resetIterationDates();
    }

    public Execution createExecution(MessageSource messageSource, Locale locale) throws TestPlanItemNotExecutableException {
        this.checkExecutable();
        CreateExecutionFromTestCaseVisitor createExecutionVisitor = new CreateExecutionFromTestCaseVisitor(this.referencedDataset, messageSource, locale);
        this.referencedTestCase.accept(createExecutionVisitor);
        return createExecutionVisitor.getCreatedExecution();
    }

    public Execution createAutomatedExecution() throws TestPlanItemNotExecutableException {
        if (!this.isAutomated()) {
            throw new NotAutomatedException();
        }
        Execution execution = this.createExecution(null, null);
        AutomatedExecutionExtender extender = new AutomatedExecutionExtender();
        extender.setAutomatedTest(this.referencedTestCase.getAutomatedTest());
        extender.setExecution(execution);
        execution.setAutomatedExecutionExtender(extender);
        return execution;
    }

    private void checkExecutable() throws TestPlanItemNotExecutableException {
        if (!this.isExecutableThroughIteration()) {
            throw new TestPlanItemNotExecutableException("Test case referenced by this item was deleted");
        }
    }

    public boolean isAutomated() {
        if (this.referencedTestCase == null) {
            return false;
        }
        return this.referencedTestCase.isAutomated() && this.getProject() != null && this.getProject().isTestAutomationEnabled();
    }

    private void resetIterationDates() {
        Iteration it = this.getIteration();
        if (it != null) {
            it.updateAutoDates(null);
        }
    }

    public void removeExecution(Execution execution) {
        boolean wasLastExecution = false;
        if (this.getLatestExecution().equals(execution)) {
            wasLastExecution = true;
        }
        ListIterator<Execution> iterator = this.executions.listIterator();
        while (iterator.hasNext()) {
            Execution exec = iterator.next();
            if (!exec.getId().equals(execution.getId())) continue;
            iterator.remove();
            break;
        }
        if (wasLastExecution) {
            this.updateExecutionStatus();
            if (this.getLatestExecution() != null) {
                this.lastExecutedOn = this.getLatestExecution().getLastExecutedOn();
                this.lastExecutedBy = this.getLatestExecution().getLastExecutedBy();
            } else {
                this.lastExecutedOn = null;
                this.lastExecutedBy = null;
            }
            Iteration iter = this.getIteration();
            if (iter != null) {
                iter.updateAutoDatesAfterExecutionDetach(this);
            }
        }
    }

    public IterationTestPlanItem createCopy() {
        IterationTestPlanItem copy = new IterationTestPlanItem();
        copy.setExecutionStatus(ExecutionStatus.READY);
        copy.setLabel(this.label);
        copy.setReferencedTestCase(this.referencedTestCase);
        copy.setUser(this.user);
        copy.referencedDataset = this.referencedDataset;
        return copy;
    }

    public Project getProject() {
        if (this.iteration != null) {
            return this.iteration.getProject();
        }
        if (!this.testSuites.isEmpty()) {
            return this.testSuites.get(0).getProject();
        }
        return null;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public boolean isExecutableThroughIteration() {
        return !this.isTestCaseDeleted();
    }

    public boolean isExecutableThroughTestSuite() {
        if (this.executions.isEmpty()) {
            return !this.isTestCaseDeleted();
        }
        return this.isLatestExecutionStillRunning();
    }

    private boolean isLatestExecutionStillRunning() {
        return this.getLatestExecution().hasUnexecutedSteps();
    }

    public boolean isTestCaseDeleted() {
        return this.getReferencedTestCase() == null;
    }

    private boolean isSameIteration(Iteration thisIteration, Iteration thatIteration) {
        boolean result = false;
        if (thisIteration.equals(thatIteration)) {
            result = true;
        } else {
            result = false;
            if (thisIteration.getId() != null && thatIteration.getId() != null) {
                result = thisIteration.getId().equals(thatIteration.getId());
            }
        }
        return result;
    }

    public void addTestSuite(@NotNull TestSuite suite) {
        TestSuite testSuite = suite;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)testSuite);
        if (!this.isSameIteration(this.iteration, suite.getIteration())) {
            throw new IllegalArgumentException("Item[" + this.id + "] dont belong to Iteration[" + suite.getIteration().getId() + "], it cannot be bound to TestSuite['" + suite.getName() + "']");
        }
        this.testSuites.add(suite);
        suite.bindTestPlanItem(this);
    }

    public void removeTestSuite(TestSuite suite) {
        long suiteId = suite.getId();
        ArrayList<TestSuite> toRemove = new ArrayList<TestSuite>();
        for (TestSuite testSuite : this.testSuites) {
            if (testSuite.getId() != suiteId) continue;
            toRemove.add(testSuite);
            suite.unBindTestPlan(this);
        }
        this.testSuites.removeAll(toRemove);
    }

    public List<TestSuite> getTestSuites() {
        return this.testSuites;
    }

    public String getTestSuiteNames() {
        StringBuilder builder = new StringBuilder();
        for (TestSuite suite : this.testSuites) {
            builder.append(suite.getName()).append(", ");
        }
        return builder.toString().replaceFirst(", $", "");
    }

    public void setTestSuites(List<TestSuite> testSuites) {
        this.testSuites = testSuites;
    }

    void setIteration(Iteration iteration) {
        this.iteration = iteration;
    }

    public Execution getLatestExecution() {
        if (!this.executions.isEmpty()) {
            return this.executions.get(this.executions.size() - 1);
        }
        return null;
    }

    public TestCaseExecutionMode getExecutionMode() {
        Execution latest = this.getLatestExecution();
        return latest == null ? TestCaseExecutionMode.UNDEFINED : latest.getExecutionMode();
    }

    public Dataset getReferencedDataset() {
        return this.referencedDataset;
    }

    public void setReferencedDataset(Dataset referencedDataset) {
        this.referencedDataset = referencedDataset;
    }

    public static Collection<IterationTestPlanItem> createTestPlanItems(TestCase testCase, Collection<Dataset> datasets) {
        ArrayList<IterationTestPlanItem> res = new ArrayList<IterationTestPlanItem>();
        if (CollectionUtils.isEmpty(datasets)) {
            res.add(new IterationTestPlanItem(testCase));
        } else {
            for (Dataset dataset : datasets) {
                res.add(new IterationTestPlanItem(testCase, dataset));
            }
        }
        return res;
    }

    public static IterationTestPlanItem createUnparameterizedTestPlanItem(TestCase testCase) {
        return new IterationTestPlanItem(testCase);
    }

    public boolean isAssignedToUser(@NotNull String userLogin) {
        String string = userLogin;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)string);
        return this.user != null && this.user.getLogin().equals(userLogin);
    }

    public void addExecutionAtPos(Execution execution, int order) {
        this.executions.add(order, execution);
        execution.notifyAddedTo(this);
    }

    public Campaign getCampaign() {
        return this.getIteration().getCampaign();
    }

    public Set<Milestone> getMilestones() {
        return this.getIteration().getCampaign().getMilestones();
    }

    @Override
    public /* synthetic */ AuditableSupport ajc$interFieldGet$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$audit() {
        return this.audit;
    }

    @Override
    public /* synthetic */ void ajc$interFieldSet$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$audit(AuditableSupport auditableSupport) {
        this.audit = auditableSupport;
    }

    @Override
    @Embedded
    @Access(value=AccessType.PROPERTY)
    public AuditableSupport getAudit() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getAudit(this);
    }

    @Override
    public String getCreatedBy() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getCreatedBy(this);
    }

    @Override
    public Date getCreatedOn() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getCreatedOn(this);
    }

    @Override
    public String getLastModifiedBy() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getLastModifiedBy(this);
    }

    @Override
    public Date getLastModifiedOn() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getLastModifiedOn(this);
    }

    @Override
    public boolean isSkipModifyAudit() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$isSkipModifyAudit(this);
    }

    @Override
    public void setAudit(AuditableSupport auditableSupport) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setAudit(this, auditableSupport);
    }

    @Override
    public void setCreatedBy(String string) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setCreatedBy(this, string);
    }

    @Override
    public void setCreatedOn(Date date) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setCreatedOn(this, date);
    }

    @Override
    public void setLastModifiedBy(String string) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setLastModifiedBy(this, string);
    }

    @Override
    public void setLastModifiedOn(Date date) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setLastModifiedOn(this, date);
    }

    @Override
    public void setSkipModifyAudit(boolean bl) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setSkipModifyAudit(this, bl);
    }
}

