/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.bugtracker;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import org.squashtest.tm.domain.bugtracker.Issue;

@Entity
public class IssueList {
    @Id
    @Column(name="ISSUE_LIST_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="issue_list_issue_list_id_seq")
    @SequenceGenerator(name="issue_list_issue_list_id_seq", sequenceName="issue_list_issue_list_id_seq", allocationSize=1)
    private Long id;
    @OneToMany(mappedBy="issueList", cascade={CascadeType.REMOVE})
    private final List<Issue> issues = new ArrayList<Issue>();

    public Long getId() {
        return this.id;
    }

    public void addIssue(Issue issue) {
        this.issues.add(issue);
        issue.setIssueList(this);
    }

    public void removeIssue(Issue issue) {
        this.removeIssue(issue.getId());
    }

    public void removeIssue(long issueId) {
        Iterator<Issue> iter = this.issues.iterator();
        while (iter.hasNext()) {
            Issue at = iter.next();
            if (at.getId() != issueId) continue;
            iter.remove();
            break;
        }
    }

    public Issue findIssue(long issueId) {
        Issue result = null;
        for (Issue at : this.issues) {
            if (at.getId() != issueId) continue;
            result = at;
            break;
        }
        return result;
    }

    public boolean hasIssues() {
        return !this.issues.isEmpty();
    }

    public List<Issue> getAllIssues() {
        return this.issues;
    }

    public int size() {
        return this.getAllIssues().size();
    }

    public boolean hasRemoteIssue(String remoteKey) {
        for (Issue issue : this.issues) {
            if (!issue.getRemoteIssueId().equals(remoteKey)) continue;
            return true;
        }
        return false;
    }
}

