/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.exception;

import org.squashtest.tm.exception.DomainException;

public class NameAlreadyInUseException
extends DomainException {
    private static final long serialVersionUID = 1395737862096099500L;
    private final String entityName;
    private final String name;
    private final EntityType entityType;

    public NameAlreadyInUseException(String entityName, String name) {
        super("The name '" + name + "' is already used by another " + entityName + " entity", "name");
        this.entityName = entityName;
        this.name = name;
        this.entityType = EntityType.GENERIC;
    }

    public NameAlreadyInUseException(EntityType type, String name) {
        super("The name '" + name + "' is already used by another " + type.entityName + " entity", "name");
        this.entityName = type.entityName;
        this.name = name;
        this.entityType = type;
    }

    public NameAlreadyInUseException(String entityName, String name, String fieldName) {
        super("The name '" + name + "' is already used by another " + entityName + " entity", fieldName);
        this.entityName = entityName;
        this.name = name;
        this.entityType = EntityType.GENERIC;
    }

    @Override
    public String getI18nKey() {
        return this.entityType.i18nKey;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Object[] getI18nParams() {
        return new Object[]{this.name, this.entityName};
    }

    public static enum EntityType {
        GENERIC("sqtm-core.error.generic.name-already-in-use", "unknown"),
        BUG_TRACKER("sqtm-core.error.generic.name-already-in-use", "BugTracker");

        public final String i18nKey;
        public final String entityName;

        private EntityType(String i18nKey, String entityName) {
            this.i18nKey = i18nKey;
            this.entityName = entityName;
        }
    }
}

