/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.users;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import org.hibernate.annotations.NamedQueries;
import org.hibernate.annotations.NamedQuery;
import org.squashtest.tm.domain.audit.Auditable;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.audit.AuditableMixinAspect;
import org.squashtest.tm.domain.audit.AuditableSupport;
import org.squashtest.tm.domain.users.Party;
import org.squashtest.tm.domain.users.PartyVisitor;
import org.squashtest.tm.domain.users.User;

@Entity
@Auditable
@Table(name="CORE_TEAM")
@PrimaryKeyJoinColumn(name="PARTY_ID")
@NamedQueries(value={@NamedQuery(name="Team.countAssociatedTeams", query="select count(*) from Team t join t.members m where m.id = ?1"), @NamedQuery(name="Team.findAllNonAssociatedTeams", query="select t from Team t where t.id not in (select ti.id from Team ti join ti.members m where m.id = ?1)")})
public class Team
extends Party
implements AuditableMixin {
    private static final String TYPE = "TEAM";
    @NotBlank
    @Size(min=0, max=50)
    private @NotBlank @Size(min=0, max=50) String name;
    private String description;
    @ManyToMany
    @JoinTable(name="CORE_TEAM_MEMBER", joinColumns={@JoinColumn(name="TEAM_ID")}, inverseJoinColumns={@JoinColumn(name="USER_ID")})
    private final Set<User> members;
    @Transient
    public AuditableSupport audit;

    public Team() {
        AuditableMixinAspect.ajc$interFieldInit$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$audit(this);
        this.members = new HashSet<User>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.trim();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Set<User> getMembers() {
        return this.members;
    }

    public void addMember(User user) {
        this.members.add(user);
    }

    public void addMembers(Collection<User> users) {
        this.members.addAll(users);
    }

    public void removeMember(User user) {
        this.members.remove(user);
    }

    public void removeMember(Collection<User> users) {
        this.members.removeAll(users);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void accept(PartyVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public /* synthetic */ AuditableSupport ajc$interFieldGet$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$audit() {
        return this.audit;
    }

    @Override
    public /* synthetic */ void ajc$interFieldSet$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$audit(AuditableSupport auditableSupport) {
        this.audit = auditableSupport;
    }

    @Override
    @Embedded
    @Access(value=AccessType.PROPERTY)
    public AuditableSupport getAudit() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getAudit(this);
    }

    @Override
    public String getCreatedBy() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getCreatedBy(this);
    }

    @Override
    public Date getCreatedOn() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getCreatedOn(this);
    }

    @Override
    public String getLastModifiedBy() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getLastModifiedBy(this);
    }

    @Override
    public Date getLastModifiedOn() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getLastModifiedOn(this);
    }

    @Override
    public boolean isSkipModifyAudit() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$isSkipModifyAudit(this);
    }

    @Override
    public void setAudit(AuditableSupport auditableSupport) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setAudit(this, auditableSupport);
    }

    @Override
    public void setCreatedBy(String string) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setCreatedBy(this, string);
    }

    @Override
    public void setCreatedOn(Date date) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setCreatedOn(this, date);
    }

    @Override
    public void setLastModifiedBy(String string) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setLastModifiedBy(this, string);
    }

    @Override
    public void setLastModifiedOn(Date date) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setLastModifiedOn(this, date);
    }

    @Override
    public void setSkipModifyAudit(boolean bl) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setSkipModifyAudit(this, bl);
    }
}

