/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.testcase;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderColumn;
import javax.persistence.SequenceGenerator;
import org.hibernate.annotations.Where;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.library.NodeContainerVisitor;
import org.squashtest.tm.domain.project.GenericLibrary;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.domain.testcase.TestCaseLibraryPluginBinding;

@Entity
public class TestCaseLibrary
extends GenericLibrary<TestCaseLibraryNode> {
    public static final String CLASS_NAME = "org.squashtest.tm.domain.testcase.TestCaseLibrary";
    private static final String SIMPLE_CLASS_NAME = "TestCaseLibrary";
    @Id
    @Column(name="TCL_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="test_case_library_tcl_id_seq")
    @SequenceGenerator(name="test_case_library_tcl_id_seq", sequenceName="test_case_library_tcl_id_seq", allocationSize=1)
    private Long id;
    @OneToMany
    @OrderColumn(name="CONTENT_ORDER")
    @JoinTable(name="TEST_CASE_LIBRARY_CONTENT", joinColumns={@JoinColumn(name="LIBRARY_ID")}, inverseJoinColumns={@JoinColumn(name="CONTENT_ID")})
    private List<TestCaseLibraryNode> rootContent = new ArrayList<TestCaseLibraryNode>();
    @OneToOne(mappedBy="testCaseLibrary")
    private GenericProject project;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="LIBRARY_ID")
    @Where(clause="LIBRARY_TYPE = 'T'")
    private Set<TestCaseLibraryPluginBinding> enabledPlugins = new HashSet<TestCaseLibraryPluginBinding>(5);

    public List<TestCaseLibraryNode> getRootContent() {
        return this.rootContent;
    }

    @Override
    public List<TestCaseLibraryNode> getContent() {
        return this.getRootContent();
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public GenericProject getProject() {
        return this.project;
    }

    @Override
    public void notifyAssociatedWithProject(GenericProject p) {
        this.project = p;
    }

    @Override
    public void removeContent(TestCaseLibraryNode node) {
        this.rootContent.remove(node);
        this.rootContent = new ArrayList<TestCaseLibraryNode>(this.rootContent);
    }

    @Override
    public Set<String> getEnabledPlugins() {
        HashSet<String> pluginIds = new HashSet<String>(this.enabledPlugins.size());
        for (TestCaseLibraryPluginBinding binding : this.enabledPlugins) {
            pluginIds.add(binding.getPluginId());
        }
        return pluginIds;
    }

    public Set<TestCaseLibraryPluginBinding> getAllPluginBindings() {
        return this.enabledPlugins;
    }

    @Override
    public void enablePlugin(String pluginId) {
        if (!this.isPluginEnabled(pluginId)) {
            TestCaseLibraryPluginBinding newBinding = new TestCaseLibraryPluginBinding(pluginId);
            this.enabledPlugins.add(newBinding);
        }
    }

    @Override
    public void disablePlugin(String pluginId) {
        TestCaseLibraryPluginBinding binding = this.getPluginBinding(pluginId);
        if (binding != null) {
            this.enabledPlugins.remove(binding);
        }
    }

    public TestCaseLibraryPluginBinding getPluginBinding(String pluginId) {
        for (TestCaseLibraryPluginBinding binding : this.enabledPlugins) {
            if (!binding.getPluginId().equals(pluginId)) continue;
            return binding;
        }
        return null;
    }

    @Override
    public boolean isPluginEnabled(String pluginId) {
        return this.getPluginBinding(pluginId) != null;
    }

    @Override
    public String getClassSimpleName() {
        return SIMPLE_CLASS_NAME;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public boolean hasContent() {
        return !this.rootContent.isEmpty();
    }

    @Override
    public void accept(NodeContainerVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Collection<TestCaseLibraryNode> getOrderedContent() {
        return this.rootContent;
    }

    @Override
    public EntityReference toEntityReference() {
        return new EntityReference(EntityType.TEST_CASE_LIBRARY, this.getId());
    }
}

