/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.testautomation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.Transient;
import org.hibernate.annotations.GenericGenerator;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.audit.Auditable;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.audit.AuditableMixinAspect;
import org.squashtest.tm.domain.audit.AuditableSupport;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.library.HasExecutionStatus;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;

@NamedQueries(value={@NamedQuery(name="automatedSuite.findAll", query="from AutomatedSuite"), @NamedQuery(name="automatedSuite.findAllById", query="from AutomatedSuite where id in (:suiteIds)"), @NamedQuery(name="automatedSuite.findAllExtenders", query="select ext from AutomatedExecutionExtender ext join ext.automatedSuite s where s.id = :suiteId"), @NamedQuery(name="automatedSuite.findAllExtendersHavingStatus", query="select ext from AutomatedExecutionExtender ext join ext.execution exe join ext.automatedSuite s where s.id = :suiteId and exe.executionStatus in (:statusList)"), @NamedQuery(name="automatedSuite.fetchForAutomationExecution", query="select distinct ext from AutomatedExecutionExtender ext join fetch ext.execution exec join fetch exec.issueList join fetch exec.attachmentList join fetch exec.testPlan itpi  join fetch itpi.referencedTestCase tc join fetch tc.automatedTest autoTest join fetch tc.nature nat join fetch nat.infoList left join fetch tc.parameters left join fetch tc.automationRequest left join fetch itpi.referencedDataset dataset left join fetch dataset.parameterValues join fetch itpi.iteration it join fetch it.campaign where ext.automatedSuite.id = :suiteId order by ext.id asc"), @NamedQuery(name="automatedSuite.countStatuses", query="select exec.executionStatus, count(exec) from AutomatedSuite asuite join asuite.executionExtenders ext join ext.execution exec where asuite.id = :id group by exec.executionStatus")})
@Entity
@Auditable
public class AutomatedSuite
implements HasExecutionStatus,
AttachmentHolder,
AuditableMixin {
    static final Set<ExecutionStatus> LEGAL_EXEC_STATUS;
    @Id
    @Column(name="SUITE_ID")
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid")
    private String id;
    @OneToMany(mappedBy="automatedSuite", cascade={CascadeType.ALL})
    @OrderBy
    private List<AutomatedExecutionExtender> executionExtenders;
    @Enumerated(value=EnumType.STRING)
    private ExecutionStatus executionStatus;
    @ManyToOne
    @JoinColumn(name="ITERATION_ID")
    private Iteration iteration;
    @ManyToOne
    @JoinColumn(name="TEST_SUITE_ID")
    private TestSuite testSuite;
    @OneToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.DETACH, CascadeType.REMOVE})
    @JoinColumn(name="ATTACHMENT_LIST_ID")
    private final AttachmentList attachmentList;
    private transient Boolean manualSlaveSelection;
    @Transient
    public AuditableSupport audit;

    static {
        HashSet<ExecutionStatus> set = new HashSet<ExecutionStatus>();
        set.add(ExecutionStatus.SUCCESS);
        set.add(ExecutionStatus.BLOCKED);
        set.add(ExecutionStatus.FAILURE);
        set.add(ExecutionStatus.RUNNING);
        set.add(ExecutionStatus.READY);
        set.add(ExecutionStatus.UNTESTABLE);
        set.add(ExecutionStatus.SETTLED);
        LEGAL_EXEC_STATUS = Collections.unmodifiableSet(set);
    }

    public AutomatedSuite() {
        AuditableMixinAspect.ajc$interFieldInit$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$audit(this);
        this.executionExtenders = new ArrayList<AutomatedExecutionExtender>();
        this.executionStatus = ExecutionStatus.READY;
        this.attachmentList = new AttachmentList();
    }

    public AutomatedSuite(Iteration iteration) {
        AuditableMixinAspect.ajc$interFieldInit$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$audit(this);
        this.executionExtenders = new ArrayList<AutomatedExecutionExtender>();
        this.executionStatus = ExecutionStatus.READY;
        this.attachmentList = new AttachmentList();
        this.iteration = iteration;
    }

    public AutomatedSuite(TestSuite testSuite) {
        AuditableMixinAspect.ajc$interFieldInit$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$audit(this);
        this.executionExtenders = new ArrayList<AutomatedExecutionExtender>();
        this.executionStatus = ExecutionStatus.READY;
        this.attachmentList = new AttachmentList();
        this.testSuite = testSuite;
    }

    public String getId() {
        return this.id;
    }

    public List<AutomatedExecutionExtender> getExecutionExtenders() {
        return this.executionExtenders;
    }

    public void setExecutionExtenders(List<AutomatedExecutionExtender> executionExtenders) {
        this.executionExtenders = executionExtenders;
    }

    public void addExtender(AutomatedExecutionExtender extender) {
        this.executionExtenders.add(extender);
        extender.setAutomatedSuite(this);
    }

    public void addExtenders(Collection<AutomatedExecutionExtender> extenders) {
        for (AutomatedExecutionExtender extender : extenders) {
            this.executionExtenders.add(extender);
        }
    }

    public boolean hasStarted() {
        for (AutomatedExecutionExtender extender : this.executionExtenders) {
            if (extender.getExecution().getExecutionStatus() == ExecutionStatus.READY) continue;
            return true;
        }
        return false;
    }

    public boolean hasEnded() {
        for (AutomatedExecutionExtender extender : this.executionExtenders) {
            if (extender.getExecution().getExecutionStatus().isTerminatedStatus()) continue;
            return false;
        }
        return true;
    }

    public boolean isManualNodeSelection() {
        if (this.manualSlaveSelection == null) {
            boolean manual = false;
            for (AutomatedExecutionExtender autoExec : this.executionExtenders) {
                manual = autoExec.getAutomatedProject().getServer().isManualSlaveSelection();
                if (manual) break;
            }
            this.manualSlaveSelection = manual;
        }
        return this.manualSlaveSelection;
    }

    @Override
    public ExecutionStatus getExecutionStatus() {
        return this.executionStatus;
    }

    public void setExecutionStatus(ExecutionStatus executionStatus) {
        this.executionStatus = executionStatus;
    }

    @Override
    public Set<ExecutionStatus> getLegalStatusSet() {
        return null;
    }

    public Iteration getIteration() {
        return this.iteration;
    }

    public TestSuite getTestSuite() {
        return this.testSuite;
    }

    @Override
    public AttachmentList getAttachmentList() {
        return this.attachmentList;
    }

    @Override
    public EntityReference toEntityReference() {
        throw new UnsupportedOperationException("Automated suites have no numeric id, what a good idea !!!");
    }

    @Override
    public /* synthetic */ AuditableSupport ajc$interFieldGet$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$audit() {
        return this.audit;
    }

    @Override
    public /* synthetic */ void ajc$interFieldSet$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$audit(AuditableSupport auditableSupport) {
        this.audit = auditableSupport;
    }

    @Override
    @Embedded
    @Access(value=AccessType.PROPERTY)
    public AuditableSupport getAudit() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getAudit(this);
    }

    @Override
    public String getCreatedBy() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getCreatedBy(this);
    }

    @Override
    public Date getCreatedOn() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getCreatedOn(this);
    }

    @Override
    public String getLastModifiedBy() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getLastModifiedBy(this);
    }

    @Override
    public Date getLastModifiedOn() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getLastModifiedOn(this);
    }

    @Override
    public boolean isSkipModifyAudit() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$isSkipModifyAudit(this);
    }

    @Override
    public void setAudit(AuditableSupport auditableSupport) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setAudit(this, auditableSupport);
    }

    @Override
    public void setCreatedBy(String string) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setCreatedBy(this, string);
    }

    @Override
    public void setCreatedOn(Date date) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setCreatedOn(this, date);
    }

    @Override
    public void setLastModifiedBy(String string) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setLastModifiedBy(this, string);
    }

    @Override
    public void setLastModifiedOn(Date date) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setLastModifiedOn(this, date);
    }

    @Override
    public void setSkipModifyAudit(boolean bl) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setSkipModifyAudit(this, bl);
    }
}

