/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.synchronisation;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.synchronisation.SynchronisationStatus;

@Entity
@Table(name="REMOTE_SYNCHRONISATION")
public class RemoteSynchronisation {
    @Id
    @Column(name="REMOTE_SYNCHRONISATION_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="remote_synchronisation_remote_synchronisation_id_seq")
    @SequenceGenerator(name="remote_synchronisation_remote_synchronisation_id_seq", sequenceName="remote_synchronisation_remote_synchronisation_id_seq", allocationSize=1)
    private long id;
    @Column(name="REMOTE_SYNCHRONISATION_NAME")
    @NotNull
    @Size(min=0, max=255)
    private @NotNull @Size(min=0, max=255) String name;
    @NotNull
    @Size(min=0, max=50)
    @Column(name="KIND")
    private @NotNull @Size(min=0, max=50) String kind;
    @Column(name="REMOTE_SELECT_TYPE")
    @Size(min=0, max=50)
    private @Size(min=0, max=50) String selectType;
    @Column(name="REMOTE_SELECT_VALUE")
    @Size(min=0, max=1000)
    private @Size(min=0, max=1000) String selectValue;
    @Column(name="LAST_SUCCESSFUL_SYNC_DATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastSuccessfulSyncDate;
    @Column(name="LAST_SYNC_DATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastSyncDate;
    @Column(name="REMOTE_SYNCHRONISATION_OPTIONS")
    @Lob
    @Type(type="org.hibernate.type.TextType")
    private String options;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PROJECT_ID")
    private Project project;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="SERVER_ID")
    private BugTracker server;
    @Column(name="SYNC_STATUS")
    @Enumerated(value=EnumType.STRING)
    private SynchronisationStatus synchronisationStatus = SynchronisationStatus.NEVER_EXECUTED;
    @Column(name="LAST_SYNC_STATUS")
    @Enumerated(value=EnumType.STRING)
    private SynchronisationStatus lastSynchronisationStatus = SynchronisationStatus.NEVER_EXECUTED;
    @Column(name="SYNC_ENABLE")
    private boolean synchronisationEnable;

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public String getSelectType() {
        return this.selectType;
    }

    public void setSelectType(String selectType) {
        this.selectType = selectType;
    }

    public String getSelectValue() {
        return this.selectValue;
    }

    public void setSelectValue(String selectValue) {
        this.selectValue = selectValue;
    }

    public Date getLastSuccessfulSyncDate() {
        return this.lastSuccessfulSyncDate;
    }

    public void setLastSuccessfulSyncDate(Date lastSuccessfulSyncDate) {
        this.lastSuccessfulSyncDate = lastSuccessfulSyncDate;
    }

    public Date getLastSyncDate() {
        return this.lastSyncDate;
    }

    public void setLastSyncDate(Date lastSyncDate) {
        this.lastSyncDate = lastSyncDate;
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public BugTracker getServer() {
        return this.server;
    }

    public void setServer(BugTracker server) {
        this.server = server;
    }

    public SynchronisationStatus getSynchronisationStatus() {
        return this.synchronisationStatus;
    }

    public void setSynchronisationStatus(SynchronisationStatus synchronisationStatus) {
        this.synchronisationStatus = synchronisationStatus;
    }

    public SynchronisationStatus getLastSynchronisationStatus() {
        return this.lastSynchronisationStatus;
    }

    public void setLastSynchronisationStatus(SynchronisationStatus lastSynchronisationStatus) {
        this.lastSynchronisationStatus = lastSynchronisationStatus;
    }

    public boolean isSynchronisationEnable() {
        return this.synchronisationEnable;
    }

    public void setSynchronisationEnable(boolean synchronisationEnable) {
        this.synchronisationEnable = synchronisationEnable;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("RemoteSynchronisation{");
        sb.append("id=").append(this.id);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", selectType='").append(this.selectType).append('\'');
        sb.append(", selectValue='").append(this.selectValue).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

