/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.servers;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import org.hibernate.annotations.Type;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.domain.users.User;

@Entity
public class StoredCredentials {
    @Id
    @Column(name="CREDENTIAL_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="stored_credentials_credential_id_seq")
    @SequenceGenerator(name="stored_credentials_credential_id_seq", sequenceName="stored_credentials_credential_id_seq", allocationSize=1)
    private Long id;
    @Column(name="ENC_VERSION")
    private int encryptionVersion;
    @Lob
    @Type(type="org.hibernate.type.TextType")
    @Column(name="ENC_CREDENTIALS")
    private String encryptedCredentials;
    @Column(name="CONTENT_TYPE")
    @Enumerated(value=EnumType.STRING)
    private ContentType contentType = ContentType.CRED;
    @ManyToOne
    @JoinColumn(name="AUTHENTICATED_SERVER")
    private ThirdPartyServer authenticatedServer;
    @ManyToOne
    @JoinColumn(name="AUTHENTICATED_USER")
    private User authenticatedUser;

    public Long getId() {
        return this.id;
    }

    public int getEncryptionVersion() {
        return this.encryptionVersion;
    }

    public String getEncryptedCredentials() {
        return this.encryptedCredentials;
    }

    public void setEncryptionVersion(int encryptionVersion) {
        this.encryptionVersion = encryptionVersion;
    }

    public void setEncryptedCredentials(String encryptedCredentials) {
        this.encryptedCredentials = encryptedCredentials;
    }

    public ThirdPartyServer getAuthenticatedServer() {
        return this.authenticatedServer;
    }

    public void setAuthenticatedServer(ThirdPartyServer authenticatedServer) {
        this.authenticatedServer = authenticatedServer;
    }

    public User getAuthenticatedUser() {
        return this.authenticatedUser;
    }

    public void setAuthenticatedUser(User authenticatedUser) {
        this.authenticatedUser = authenticatedUser;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public boolean isSystemCredentials() {
        return this.authenticatedUser == null;
    }

    public static enum ContentType {
        CRED,
        CONF;

    }
}

