/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.search;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.TestCase;

public class IndexMonitor {
    private static final BigInteger CENT = BigInteger.valueOf(100L);
    private static Map<Class<?>, IndexMonitor> monitors = new HashMap();
    private static IndexMonitor total = new IndexMonitor();
    private final AtomicLong totalCount = new AtomicLong();
    private final AtomicLong documentsBuilt = new AtomicLong();

    static {
        monitors.put(TestCase.class, new IndexMonitor());
        monitors.put(RequirementVersion.class, new IndexMonitor());
        monitors.put(IterationTestPlanItem.class, new IndexMonitor());
    }

    public void addToTotalCount(long count) {
        this.totalCount.addAndGet(count);
    }

    public void addToDocumentsBuilded(int doc) {
        this.documentsBuilt.addAndGet(doc);
    }

    public static Map<Class<?>, IndexMonitor> getMonitors() {
        return monitors;
    }

    public static IndexMonitor getTotal() {
        return total;
    }

    public BigInteger getTotalCount() {
        return BigInteger.valueOf(this.totalCount.get());
    }

    public BigInteger getDocumentsBuilt() {
        return BigInteger.valueOf(this.documentsBuilt.get());
    }

    public BigInteger getPercentComplete() {
        if (this.getTotalCount().equals(BigInteger.ZERO)) {
            return CENT;
        }
        return this.getDocumentsBuilt().multiply(CENT).divide(this.getTotalCount());
    }

    public static void resetTotal() {
        total = new IndexMonitor();
    }
}

