/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.requirement;

import java.net.URL;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.tm.domain.requirement.RemoteRequirementPerimeterStatus;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;

@Entity
public class RequirementSyncExtender {
    @Id
    @Column(name="REQ_SYNC_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="requirement_sync_extender_req_sync_id_seq")
    @SequenceGenerator(name="requirement_sync_extender_req_sync_id_seq", sequenceName="requirement_sync_extender_req_sync_id_seq", allocationSize=1)
    private Long id;
    @OneToOne
    @JoinColumn(name="REQUIREMENT_ID", referencedColumnName="RLN_ID")
    private Requirement requirement;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="SERVER_ID", referencedColumnName="BUGTRACKER_ID")
    private BugTracker server;
    @Column
    private String remoteReqId;
    @Column
    private String remoteProjectId;
    @Column
    private String remoteFilterName;
    @Column(name="REMOTE_REQ_URL")
    private URL remoteUrl;
    @Column(name="REMOTE_LAST_UPDATED")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date remoteLastUpdated;
    @ManyToOne
    @JoinColumn(name="REMOTE_SYNCHRONISATION_ID")
    private RemoteSynchronisation remoteSynchronisation;
    @Column
    private String remoteParentId;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    @Column(name="REMOTE_REQ_PERIMETER_STATUS")
    private RemoteRequirementPerimeterStatus remoteRequirementPerimeterStatus = RemoteRequirementPerimeterStatus.UNKNOWN;

    public void synchronize(RequirementVersion v) {
        this.requirement.setName(v.getName());
        this.requirement.setReference(v.getReference());
        this.requirement.setCategory(v.getCategory());
        this.requirement.setCriticality(v.getCriticality());
        this.requirement.setDescription(v.getDescription());
        this.requirement.setStatus(v.getStatus());
    }

    public Requirement getRequirement() {
        return this.requirement;
    }

    public void setRequirement(Requirement requirement) {
        this.requirement = requirement;
    }

    public String getRemoteReqId() {
        return this.remoteReqId;
    }

    public void setRemoteReqId(String remoteReqId) {
        this.remoteReqId = remoteReqId;
    }

    public String getRemoteProjectId() {
        return this.remoteProjectId;
    }

    public void setRemoteProjectId(String remoteProjectId) {
        this.remoteProjectId = remoteProjectId;
    }

    public String getRemoteFilterName() {
        return this.remoteFilterName;
    }

    public void setRemoteFilterName(String remoteFilterName) {
        this.remoteFilterName = remoteFilterName;
    }

    public BugTracker getServer() {
        return this.server;
    }

    public void setServer(BugTracker server) {
        this.server = server;
    }

    public URL getRemoteUrl() {
        return this.remoteUrl;
    }

    public void setRemoteUrl(URL remoteUrl) {
        this.remoteUrl = remoteUrl;
    }

    public Date getRemoteLastUpdated() {
        return this.remoteLastUpdated;
    }

    public void setRemoteLastUpdated(Date remoteLastUpdated) {
        this.remoteLastUpdated = remoteLastUpdated;
    }

    public RemoteSynchronisation getRemoteSynchronisation() {
        return this.remoteSynchronisation;
    }

    public void setRemoteSynchronisation(RemoteSynchronisation remoteSynchronisation) {
        this.remoteSynchronisation = remoteSynchronisation;
    }

    public String getRemoteParentId() {
        return this.remoteParentId;
    }

    public void setRemoteParentId(String remoteParentId) {
        this.remoteParentId = remoteParentId;
    }

    public RemoteRequirementPerimeterStatus getRemoteRequirementPerimeterStatus() {
        return this.remoteRequirementPerimeterStatus;
    }

    public void setRemoteRequirementPerimeterStatus(RemoteRequirementPerimeterStatus remoteRequirementPerimeterStatus) {
        this.remoteRequirementPerimeterStatus = remoteRequirementPerimeterStatus;
    }
}

