/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.requirement;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.squashtest.tm.domain.Level;

public enum RequirementStatus implements Level
{
    WORK_IN_PROGRESS(1){

        @Override
        public Set<RequirementStatus> getAvailableNextStatus() {
            Set<RequirementStatus> next = this.defaultAvailableSet();
            next.add(UNDER_REVIEW);
            return next;
        }

        @Override
        public boolean isRequirementModifiable() {
            return true;
        }

        @Override
        public boolean getAllowsStatusUpdate() {
            return true;
        }

        @Override
        public boolean isRequirementLinkable() {
            return true;
        }

        @Override
        public Set<RequirementStatus> getDisabledStatus() {
            return this.returnDisabledStatus();
        }
    }
    ,
    UNDER_REVIEW(2){

        @Override
        public Set<RequirementStatus> getAvailableNextStatus() {
            Set<RequirementStatus> next = this.defaultAvailableSet();
            next.add(WORK_IN_PROGRESS);
            next.add(APPROVED);
            return next;
        }

        @Override
        public boolean isRequirementModifiable() {
            return true;
        }

        @Override
        public boolean getAllowsStatusUpdate() {
            return true;
        }

        @Override
        public boolean isRequirementLinkable() {
            return true;
        }

        @Override
        public Set<RequirementStatus> getDisabledStatus() {
            return this.returnDisabledStatus();
        }
    }
    ,
    APPROVED(3){

        @Override
        public Set<RequirementStatus> getAvailableNextStatus() {
            Set<RequirementStatus> next = this.defaultAvailableSet();
            next.add(UNDER_REVIEW);
            next.add(WORK_IN_PROGRESS);
            return next;
        }

        @Override
        public boolean isRequirementModifiable() {
            return false;
        }

        @Override
        public boolean getAllowsStatusUpdate() {
            return true;
        }

        @Override
        public boolean isRequirementLinkable() {
            return true;
        }

        @Override
        public Set<RequirementStatus> getDisabledStatus() {
            return this.returnDisabledStatus();
        }
    }
    ,
    OBSOLETE(4){

        @Override
        public Set<RequirementStatus> getAvailableNextStatus() {
            Set<RequirementStatus> next = this.defaultAvailableSet();
            next.add(UNDER_REVIEW);
            next.add(WORK_IN_PROGRESS);
            next.add(APPROVED);
            return next;
        }

        @Override
        public boolean isRequirementModifiable() {
            return false;
        }

        @Override
        public boolean getAllowsStatusUpdate() {
            return true;
        }

        @Override
        public boolean isRequirementLinkable() {
            return false;
        }

        @Override
        public Set<RequirementStatus> getDisabledStatus() {
            return this.returnDisabledStatus();
        }
    };

    private static final String I18N_KEY_ROOT = "requirement.status.";
    private final int level;

    private RequirementStatus(int level) {
        this.level = level;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    public abstract Set<RequirementStatus> getAvailableNextStatus();

    public abstract boolean isRequirementModifiable();

    public abstract boolean getAllowsStatusUpdate();

    public abstract boolean isRequirementLinkable();

    protected Set<RequirementStatus> defaultAvailableSet() {
        TreeSet<RequirementStatus> next = new TreeSet<RequirementStatus>();
        if (OBSOLETE != this) {
            next.add(OBSOLETE);
        }
        next.add(this);
        return next;
    }

    public static StringComparator stringComparator() {
        return new StringComparator();
    }

    public String getI18nKey() {
        return I18N_KEY_ROOT + this.name();
    }

    public boolean isTransitionLegal(RequirementStatus newStatus) {
        return this.getAvailableNextStatus().contains(newStatus);
    }

    public abstract Set<RequirementStatus> getDisabledStatus();

    protected Set<RequirementStatus> returnDisabledStatus() {
        TreeSet<RequirementStatus> disabledStatus = new TreeSet<RequirementStatus>();
        RequirementStatus[] requirementStatusArray = RequirementStatus.values();
        int n = requirementStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            RequirementStatus next = requirementStatusArray[n2];
            if (!this.isTransitionLegal(next)) {
                disabledStatus.add(next);
            }
            ++n2;
        }
        return disabledStatus;
    }

    /* synthetic */ RequirementStatus(String string, int n, int n2, RequirementStatus requirementStatus) {
        this(n2);
    }

    private static class StringComparator
    implements Comparator<String> {
        private StringComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            RequirementStatus status2;
            RequirementStatus status1;
            try {
                String comparableString1 = this.removeDisableString(o1);
                status1 = RequirementStatus.valueOf(comparableString1);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return 1;
            }
            try {
                String comparableString2 = this.removeDisableString(o2);
                status2 = RequirementStatus.valueOf(comparableString2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return -1;
            }
            return status1.compareTo(status2);
        }

        private String removeDisableString(String o) {
            String newString = o;
            String disabled = "disabled.";
            if (o.startsWith(disabled)) {
                newString = o.substring(disabled.length());
            }
            return newString;
        }
    }
}

