/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.requirement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.OrderColumn;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.core.foundation.exception.NullArgumentException;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.library.NodeContainer;
import org.squashtest.tm.domain.library.NodeContainerVisitor;
import org.squashtest.tm.domain.library.NodeVisitor;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.HighLevelRequirement;
import org.squashtest.tm.domain.requirement.ManagementMode;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.requirement.RequirementLibraryNodeVisitor;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.domain.requirement.RequirementSyncExtender;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.requirement.RequirementVersionNumberComparator;
import org.squashtest.tm.exception.DuplicateNameException;
import org.squashtest.tm.exception.NoVerifiableRequirementVersionException;
import org.squashtest.tm.exception.requirement.ForbiddenHighLevelHierarchyException;
import org.squashtest.tm.exception.requirement.IllegalRequirementVersionCreationException;

@Entity
@PrimaryKeyJoinColumn(name="RLN_ID")
public class Requirement
extends RequirementLibraryNode<RequirementVersion>
implements NodeContainer<Requirement> {
    private static final String REQUIREMENT_FOLDER_SUFFIX = "_";
    public static final String CLASS_NAME = "org.squashtest.tm.domain.requirement.Requirement";
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="CURRENT_VERSION_ID")
    protected RequirementVersion resource;
    @OneToMany(mappedBy="requirement", cascade={CascadeType.ALL})
    @OrderBy(value="versionNumber DESC")
    private List<RequirementVersion> versions = new ArrayList<RequirementVersion>();
    @OneToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @OrderColumn(name="CONTENT_ORDER")
    @JoinTable(name="RLN_RELATIONSHIP", joinColumns={@JoinColumn(name="ANCESTOR_ID")}, inverseJoinColumns={@JoinColumn(name="DESCENDANT_ID")})
    private List<Requirement> children = new ArrayList<Requirement>();
    @Column
    @Enumerated(value=EnumType.STRING)
    private ManagementMode mode = ManagementMode.NATIVE;
    @OneToOne(mappedBy="requirement", cascade={CascadeType.REMOVE, CascadeType.PERSIST}, optional=true)
    private RequirementSyncExtender syncExtender;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="HIGH_LEVEL_REQUIREMENT_ID")
    private HighLevelRequirement highLevelRequirement;

    protected Requirement() {
    }

    public Requirement(@NotNull RequirementVersion version) {
        this.resource = version;
        this.addVersion(version);
    }

    protected void addVersion(RequirementVersion version) {
        if (!this.versions.isEmpty() && this.isSynchronizedPrivately()) {
            throw new IllegalRequirementVersionCreationException();
        }
        this.versions.add(version);
        version.setRequirement(this);
    }

    @Override
    public void setName(String name) {
        this.resource.setName(name);
    }

    @Override
    public void setDescription(String description) {
        this.resource.setDescription(description);
    }

    @Override
    public void accept(RequirementLibraryNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public String getReference() {
        return this.resource.getReference();
    }

    public void setReference(String reference) {
        this.resource.setReference(reference);
    }

    public List<RequirementVersion> getRequirementVersions() {
        return Collections.unmodifiableList(this.versions);
    }

    @Override
    public Requirement createCopy() {
        Requirement copy = new Requirement();
        copy.notifyAssociatedWithProject((Project)this.getProject());
        RequirementVersion latestVersionCopy = this.getCurrentVersion().createPastableCopy(copy);
        copy.addVersion(latestVersionCopy);
        copy.resource = latestVersionCopy;
        return copy;
    }

    public SortedMap<RequirementVersion, RequirementVersion> addPreviousVersionsCopiesToCopy(Requirement copy) {
        TreeMap<RequirementVersion, RequirementVersion> copyBySource = new TreeMap<RequirementVersion, RequirementVersion>(new RequirementVersionNumberComparator());
        for (RequirementVersion sourceVersion : this.versions) {
            if (!this.isNotLatestVersion(sourceVersion) || !sourceVersion.isNotObsolete()) continue;
            RequirementVersion copyVersion = sourceVersion.createPastableCopy();
            copyBySource.put(sourceVersion, copyVersion);
            copy.addVersion(copyVersion);
        }
        return copyBySource;
    }

    private boolean isNotLatestVersion(RequirementVersion sourceVersion) {
        return !this.getCurrentVersion().equals(sourceVersion);
    }

    public RequirementCriticality getCriticality() {
        return this.resource.getCriticality();
    }

    public void setCriticality(RequirementCriticality criticality) {
        this.resource.setCriticality(criticality);
    }

    public InfoListItem getCategory() {
        return this.resource.getCategory();
    }

    public void setCategory(InfoListItem category) {
        this.resource.setCategory(category);
    }

    public void setStatus(RequirementStatus status) {
        this.resource.setStatus(status);
    }

    public RequirementStatus getStatus() {
        return this.resource.getStatus();
    }

    public boolean isLinkable() {
        return this.getStatus().isRequirementLinkable();
    }

    public boolean isModifiable() {
        return this.getStatus().isRequirementModifiable();
    }

    @Override
    public String getName() {
        return this.resource.getName();
    }

    @Override
    public String getDescription() {
        return this.resource.getDescription();
    }

    public RequirementVersion getCurrentVersion() {
        return this.resource;
    }

    @Override
    public RequirementVersion getResource() {
        return this.resource;
    }

    public void setCurrentVersion(RequirementVersion version) {
        this.resource = version;
    }

    public void increaseVersion() {
        RequirementVersion next;
        RequirementVersion previous = this.resource;
        this.resource = next = previous.createNextVersion();
        this.versions.add(0, next);
        next.setRequirement(this);
    }

    public void increaseVersion(RequirementVersion newVersion) {
        newVersion.setVersionNumber(this.resource.getVersionNumber() + 1);
        this.resource = newVersion;
        this.versions.add(0, newVersion);
        newVersion.setRequirement(this);
    }

    public RequirementVersion getDefaultVerifiableVersion() {
        RequirementVersion verifiable = this.findLatestApprovedVersion();
        if (verifiable == null) {
            verifiable = this.findLatestNonObsoleteVersion();
        }
        if (verifiable == null) {
            throw new NoVerifiableRequirementVersionException(this);
        }
        return verifiable;
    }

    private RequirementVersion findLatestApprovedVersion() {
        for (RequirementVersion version : this.versions) {
            if (RequirementStatus.APPROVED != version.getStatus()) continue;
            return version;
        }
        return null;
    }

    private RequirementVersion findLatestNonObsoleteVersion() {
        for (RequirementVersion version : this.versions) {
            if (!version.isNotObsolete()) continue;
            return version;
        }
        return null;
    }

    public List<RequirementVersion> getUnmodifiableVersions() {
        return Collections.unmodifiableList(this.versions);
    }

    public boolean hasNonObsoleteVersion() {
        for (RequirementVersion version : this.versions) {
            if (version.getStatus() == RequirementStatus.OBSOLETE) continue;
            return true;
        }
        return false;
    }

    public RequirementVersion findLastNonObsoleteVersion() {
        for (RequirementVersion version : this.versions) {
            if (version.getStatus() == RequirementStatus.OBSOLETE) continue;
            return version;
        }
        return null;
    }

    public RequirementVersion findRequirementVersion(int versionNumber) {
        for (RequirementVersion requirementVersion : this.versions) {
            if (requirementVersion.getVersionNumber() != versionNumber) continue;
            return requirementVersion;
        }
        return null;
    }

    @Override
    public void addContent(@NotNull Requirement child) throws DuplicateNameException, NullArgumentException {
        Requirement requirement = child;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)requirement);
        this.addContent(child, this.children.size());
    }

    private void checkAddingContentIsAllowed(Requirement child) {
        if (child.isHighLevel()) {
            throw new ForbiddenHighLevelHierarchyException();
        }
    }

    @Override
    public void addContent(@NotNull Requirement child, int position) throws DuplicateNameException, NullArgumentException {
        Requirement requirement = child;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)requirement);
        this.checkAddingContentIsAllowed(child);
        if (position >= this.children.size()) {
            this.children.add(child);
        } else {
            this.children.add(position, child);
        }
        this.children = new ArrayList<Requirement>(this.children);
        child.notifyAssociatedWithProject((Project)this.getProject());
    }

    @Override
    public boolean isContentNameAvailable(String name) {
        for (Requirement child : this.children) {
            if (!child.getName().equals(name)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<Requirement> getContent() {
        return this.children;
    }

    @Override
    public Collection<Requirement> getOrderedContent() {
        return this.children;
    }

    @Override
    public boolean hasContent() {
        return !this.children.isEmpty();
    }

    @Override
    public void removeContent(Requirement exChild) throws NullArgumentException {
        this.children.remove(exChild);
        this.children = new ArrayList<Requirement>(this.children);
    }

    @Override
    public List<String> getContentNames() {
        ArrayList<String> contentNames = new ArrayList<String>(this.children.size());
        for (Requirement child : this.children) {
            contentNames.add(child.getName());
        }
        return contentNames;
    }

    @Override
    public void accept(NodeContainerVisitor visitor) {
        visitor.visit(this);
    }

    public RequirementVersion findByMilestone(Milestone milestone) {
        for (RequirementVersion version : this.versions) {
            if (!version.isMemberOf(milestone)) continue;
            return version;
        }
        return null;
    }

    public boolean meOrMyChildHaveAVersionBoundToMilestone(Milestone milestone) {
        if (this.findByMilestone(milestone) != null) {
            return true;
        }
        for (Requirement child : this.children) {
            if (!child.meOrMyChildHaveAVersionBoundToMilestone(milestone)) continue;
            return true;
        }
        return false;
    }

    public void addExistingRequirementVersion(RequirementVersion requirementVersion) {
        Integer newVersionNumber = requirementVersion.getVersionNumber();
        if (this.findRequirementVersion(newVersionNumber) == null) {
            this.versions.add(0, requirementVersion);
            requirementVersion.setRequirement(this);
            if (newVersionNumber > this.resource.getVersionNumber()) {
                this.resource = requirementVersion;
            }
        } else {
            throw new IllegalArgumentException("RequirementVersion with version number " + newVersionNumber + " already exist in this Requirement, id : " + this.getId());
        }
    }

    public RequirementVersion findLastNonObsoleteVersionAfterImport() {
        TreeMap<Integer, RequirementVersion> sortedVersions = new TreeMap<Integer, RequirementVersion>();
        for (RequirementVersion version : this.versions) {
            if (version.getStatus() == RequirementStatus.OBSOLETE) continue;
            sortedVersions.put(version.getVersionNumber(), version);
        }
        return sortedVersions.isEmpty() ? null : (RequirementVersion)sortedVersions.get(sortedVersions.lastKey());
    }

    public String createFolderNameFromRequirement() {
        RequirementVersion currentVersion = this.getCurrentVersion();
        String fullName = String.valueOf(currentVersion.getFullName()) + REQUIREMENT_FOLDER_SUFFIX;
        return StringUtils.left((String)fullName, (int)255);
    }

    public RequirementSyncExtender getSyncExtender() {
        return this.syncExtender;
    }

    public void setSyncExtender(RequirementSyncExtender syncExtender) {
        this.mode = ManagementMode.SYNCHRONIZED;
        this.syncExtender = syncExtender;
    }

    public void removeSyncExtender() {
        this.mode = ManagementMode.NATIVE;
        this.syncExtender = null;
    }

    public boolean isSynchronized() {
        return this.isSynchronizedPrivately();
    }

    private boolean isSynchronizedPrivately() {
        return this.mode == ManagementMode.SYNCHRONIZED && this.syncExtender != null;
    }

    @Override
    public boolean allowContentWithIdenticalName() {
        return true;
    }

    @Override
    public EntityReference toEntityReference() {
        return new EntityReference(EntityType.REQUIREMENT, this.getId());
    }

    public boolean isHighLevel() {
        return false;
    }

    public HighLevelRequirement getHighLevelRequirement() {
        return this.highLevelRequirement;
    }

    public void setHighLevelRequirement(HighLevelRequirement highLevelRequirement) {
        this.highLevelRequirement = highLevelRequirement;
    }
}

