/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.query;

import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedAttributeNode;
import javax.persistence.NamedEntityGraph;
import javax.persistence.NamedSubgraph;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.query.ColumnRole;
import org.squashtest.tm.domain.query.ColumnType;
import org.squashtest.tm.domain.query.DataType;
import org.squashtest.tm.domain.query.QueryModel;
import org.squashtest.tm.domain.query.SpecializedEntityType;

@Entity
@Table(name="QUERY_COLUMN_PROTOTYPE")
@NamedEntityGraph(name="graph.QueryColumnPrototype.fetchWithSubQuery", attributeNodes={@NamedAttributeNode(value="subQuery", subgraph="columnProto")}, subgraphs={@NamedSubgraph(name="columnProto", attributeNodes={@NamedAttributeNode(value="aggregationColumns"), @NamedAttributeNode(value="filterColumns"), @NamedAttributeNode(value="projectionColumns"), @NamedAttributeNode(value="orderingColumns")})})
public class QueryColumnPrototype {
    @Id
    @Column(name="QUERY_COLUMN_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="query_column_prototype_query_column_id_seq")
    @SequenceGenerator(name="query_column_prototype_query_column_id_seq", sequenceName="query_column_prototype_query_column_id_seq", allocationSize=1)
    private Long id;
    @Enumerated(value=EnumType.STRING)
    private ColumnType columnType = ColumnType.ATTRIBUTE;
    @OneToOne
    @JoinColumn(name="SUBQUERY_ID", insertable=false)
    private QueryModel subQuery = new QueryModel();
    @NotBlank
    private String label;
    @Embedded
    private SpecializedEntityType specializedType;
    @CollectionTable(name="CHART_COLUMN_ROLE", joinColumns={@JoinColumn(name="CHART_COLUMN_ID")})
    @ElementCollection
    @Enumerated(value=EnumType.STRING)
    @Column(name="ROLE")
    private Set<ColumnRole> role;
    @Enumerated(value=EnumType.STRING)
    private DataType dataType;
    private String attributeName;
    private boolean business = true;

    public QueryColumnPrototype() {
    }

    public QueryColumnPrototype(ColumnType columnType, QueryModel subQuery, @NotBlank String label, SpecializedEntityType specializedType, String attributeName, Set<ColumnRole> role, DataType dataType, boolean business) {
        this.columnType = columnType;
        this.subQuery = subQuery;
        this.label = label;
        this.specializedType = specializedType;
        this.attributeName = attributeName;
        this.role = role;
        this.dataType = dataType;
        this.business = business;
    }

    public Long getId() {
        return this.id;
    }

    public ColumnType getColumnType() {
        return this.columnType;
    }

    public QueryModel getSubQuery() {
        return this.subQuery;
    }

    public String getLabel() {
        return this.label;
    }

    public SpecializedEntityType getSpecializedType() {
        return this.specializedType;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public Set<ColumnRole> getRole() {
        return this.role;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public boolean isBusiness() {
        return this.business;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public EntityType getEntityType() {
        return this.specializedType.getEntityType();
    }

    public boolean representsEntityItself() {
        return this.columnType == ColumnType.ENTITY;
    }
}

