/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.project;

import java.util.Objects;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.project.AutomationWorkflowType;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.requirement.RequirementLibrary;
import org.squashtest.tm.domain.testcase.TestCaseLibrary;

public class AdministrableProject {
    private final GenericProject project;
    private boolean deletable = false;
    private boolean template = false;

    public AdministrableProject(GenericProject project) {
        this.project = project;
    }

    public boolean isDeletable() {
        return this.deletable;
    }

    public void setDeletable(boolean deletable) {
        this.deletable = deletable;
    }

    public String getLabel() {
        return this.project.getLabel();
    }

    public Long getId() {
        return this.project.getId();
    }

    public String getDescription() {
        return this.project.getDescription();
    }

    public String getName() {
        return this.project.getName();
    }

    public boolean isActive() {
        return this.project.isActive();
    }

    public TestCaseLibrary getTestCaseLibrary() {
        return this.project.getTestCaseLibrary();
    }

    public RequirementLibrary getRequirementLibrary() {
        return this.project.getRequirementLibrary();
    }

    public CampaignLibrary getCampaignLibrary() {
        return this.project.getCampaignLibrary();
    }

    public GenericProject getProject() {
        return this.project;
    }

    public boolean isTemplate() {
        return this.template;
    }

    public void setTemplate(boolean template) {
        this.template = template;
    }

    public boolean allowTcModifDuringExec() {
        return this.project.allowTcModifDuringExec();
    }

    public boolean allowAutomationWorkflow() {
        return this.project.isAllowAutomationWorkflow();
    }

    public boolean useTreeStructureInScmRepo() {
        return this.project.isUseTreeStructureInScmRepo();
    }

    public AutomationWorkflowType getAutomationWorkflowType() {
        return this.project.getAutomationWorkflowType();
    }

    public String getAutomatedSuitesLifetime() {
        Integer automatedSuitesLifetime = this.project.getAutomatedSuitesLifetime();
        if (Objects.isNull(automatedSuitesLifetime)) {
            return "";
        }
        return String.valueOf(automatedSuitesLifetime);
    }
}

