/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.planning;

import java.util.Calendar;
import java.util.Date;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.squashtest.tm.domain.planning.WorkloadCalendar;

public class StandardWorkloadCalendar
implements WorkloadCalendar {
    private static final float BUSINESS_DAY_WORKLOAD = 1.0f;
    private static final float WEEKEND_DAY_WORKLOAD = 0.0f;

    @Override
    public float getWorkload(Date date) {
        return this.isWeekend(date) ? 0.0f : 1.0f;
    }

    @Override
    public float getWorkload(Date start, Date end) {
        return this.getWorkload(new LocalDate((Object)start), new LocalDate((Object)end));
    }

    public float getWorkload(LocalDate start, LocalDate end) {
        if (end.isBefore((ReadablePartial)start)) {
            throw new IllegalArgumentException("dashboard.error.date");
        }
        LocalDate lstart = this.skipWeekendToMonday(start);
        LocalDate lend = this.truncateWeekendToLastFriday(end);
        if (lend.isBefore((ReadablePartial)lstart)) {
            return (float)Days.daysBetween((ReadablePartial)start, (ReadablePartial)end).getDays() * 0.0f;
        }
        int daysbetween = Days.daysBetween((ReadablePartial)lstart, (ReadablePartial)lend).getDays() + 1;
        int adjustedDaysbetween = daysbetween + lstart.getDayOfWeek() - 1;
        int nbWeekend = adjustedDaysbetween / 7;
        int nbweekdays = daysbetween - nbWeekend * 2;
        return (float)nbweekdays * 1.0f;
    }

    private boolean isWeekend(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int day = c.get(7);
        return day == 7 || day == 1;
    }

    private boolean isWeekend(LocalDate date) {
        return date.getDayOfWeek() == 6 || date.getDayOfWeek() == 7;
    }

    private LocalDate skipWeekendToMonday(LocalDate date) {
        if (this.isWeekend(date)) {
            return date.plusWeeks(1).withDayOfWeek(1);
        }
        return date;
    }

    private LocalDate truncateWeekendToLastFriday(LocalDate date) {
        if (this.isWeekend(date)) {
            return date.withDayOfWeek(5);
        }
        return date;
    }
}

