/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.milestone;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.squashtest.tm.domain.Level;

public enum MilestoneStatus implements Level
{
    PLANNED(1, true, false, false, false),
    IN_PROGRESS(2, true, true, true, true),
    FINISHED(3, true, true, true, true),
    LOCKED(4, false, false, false, false);

    private static final String I18N_KEY_ROOT = "milestone.status.";
    private final int level;
    private final boolean isBindableToProject;
    private final boolean isBindableToObject;
    private final boolean allowObjectCreateAndDelete;
    private final boolean allowObjectModification;
    public static final List<MilestoneStatus> MILESTONE_BLOCKING_STATUSES;

    static {
        MILESTONE_BLOCKING_STATUSES = Arrays.stream(MilestoneStatus.values()).filter(status -> !status.allowObjectCreateAndDelete).filter(status -> !status.allowObjectModification).collect(Collectors.toList());
    }

    private MilestoneStatus(int level, boolean isBindableToProject, boolean isBindableToObject, boolean allowObjectCreateAndDelete, boolean allowObjectModification) {
        this.level = level;
        this.isBindableToProject = isBindableToProject;
        this.isBindableToObject = isBindableToObject;
        this.allowObjectCreateAndDelete = allowObjectCreateAndDelete;
        this.allowObjectModification = allowObjectModification;
    }

    public static MilestoneStatus getByLevel(int level) {
        MilestoneStatus[] milestoneStatusArray = MilestoneStatus.values();
        int n = milestoneStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            MilestoneStatus status = milestoneStatusArray[n2];
            if (status.getLevel() == level) {
                return status;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Does not match any level : " + level);
    }

    public static List<MilestoneStatus> getAllStatusAllowingObjectBind() {
        ArrayList<MilestoneStatus> result = new ArrayList<MilestoneStatus>();
        MilestoneStatus[] milestoneStatusArray = MilestoneStatus.values();
        int n = milestoneStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            MilestoneStatus status = milestoneStatusArray[n2];
            if (status.isBindableToObject) {
                result.add(status);
            }
            ++n2;
        }
        return result;
    }

    public String getI18nKey() {
        return I18N_KEY_ROOT + this.name();
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    public boolean isBindableToProject() {
        return this.isBindableToProject;
    }

    public boolean isBindableToObject() {
        return this.isBindableToObject;
    }

    public boolean isAllowObjectCreateAndDelete() {
        return this.allowObjectCreateAndDelete;
    }

    public boolean isAllowObjectModification() {
        return this.allowObjectModification;
    }
}

