/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.library;

import javax.persistence.CascadeType;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToOne;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.project.Project;

@MappedSuperclass
public abstract class GenericLibraryNode
implements LibraryNode,
AttachmentHolder {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PROJECT_ID")
    private Project project;
    @NotBlank
    @Size(max=255)
    private @NotBlank @Size(max=255) String name;
    @Lob
    @Type(type="org.hibernate.type.TextType")
    private String description;
    @OneToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.DETACH, CascadeType.REMOVE}, fetch=FetchType.LAZY)
    @JoinColumn(name="ATTACHMENT_LIST_ID", updatable=false)
    private final AttachmentList attachmentList = new AttachmentList();

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public void setName(String name) {
        if (name != null) {
            this.name = name.trim();
        }
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void notifyAssociatedWithProject(Project project) {
        this.project = project;
    }

    @Override
    public AttachmentList getAttachmentList() {
        return this.attachmentList;
    }

    protected abstract Class<? extends GenericLibraryNode> getGenericNodeClass();

    public int hashCode() {
        int result = 1;
        Long id = this.getId();
        Class<? extends GenericLibraryNode> mygenericClass = this.getGenericNodeClass();
        result = 31 * result + (id == null ? 0 : id.hashCode());
        result = 31 * result + (mygenericClass == null ? 0 : mygenericClass.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!GenericLibraryNode.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        GenericLibraryNode other = (GenericLibraryNode)obj;
        Long id = this.getId();
        Class<? extends GenericLibraryNode> mygenericClass = this.getGenericNodeClass();
        if (id == null ? other.getId() != null : !id.equals(other.getId())) {
            return false;
        }
        return mygenericClass.equals(other.getGenericNodeClass());
    }
}

