/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.infolist;

import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.exception.customfield.CodeAlreadyExistsException;

public enum SystemInfoListItemCode {
    CAT_FUNCTIONAL("CAT_FUNCTIONAL"),
    CAT_NON_FUNCTIONAL("CAT_NON_FUNCTIONAL"),
    CAT_USE_CASE("CAT_USE_CASE"),
    CAT_BUSINESS("CAT_BUSINESS"),
    CAT_TEST_REQUIREMENT("CAT_TEST_REQUIREMENT"),
    CAT_UNDEFINED("CAT_UNDEFINED"),
    CAT_ERGONOMIC("CAT_ERGONOMIC"),
    CAT_PERFORMANCE("CAT_PERFORMANCE"),
    CAT_TECHNICAL("CAT_TECHNICAL"),
    CAT_USER_STORY("CAT_USER_STORY"),
    CAT_SECURITY("CAT_SECURITY"),
    NAT_UNDEFINED("NAT_UNDEFINED"),
    NAT_FUNCTIONAL_TESTING("NAT_FUNCTIONAL_TESTING"),
    NAT_BUSINESS_TESTING("NAT_BUSINESS_TESTING"),
    NAT_USER_TESTING("NAT_USER_TESTING"),
    NAT_NON_FUNCTIONAL_TESTING("NAT_NON_FUNCTIONAL_TESTING"),
    NAT_PERFORMANCE_TESTING("NAT_PERFORMANCE_TESTING"),
    NAT_SECURITY_TESTING("NAT_SECURITY_TESTING"),
    NAT_ATDD("NAT_ATDD"),
    TYP_UNDEFINED("TYP_UNDEFINED"),
    TYP_COMPLIANCE_TESTING("TYP_COMPLIANCE_TESTING"),
    TYP_CORRECTION_TESTING("TYP_CORRECTION_TESTING"),
    TYP_EVOLUTION_TESTING("TYP_EVOLUTION_TESTING"),
    TYP_REGRESSION_TESTING("TYP_REGRESSION_TESTING"),
    TYP_END_TO_END_TESTING("TYP_END_TO_END_TESTING"),
    TYP_PARTNER_TESTING("TYP_PARTNER_TESTING");

    private final String code;

    private SystemInfoListItemCode(String code) {
        this.code = code;
    }

    public static void verifyModificationPermission(InfoListItem item) {
        SystemInfoListItemCode[] systemInfoListItemCodeArray = SystemInfoListItemCode.values();
        int n = systemInfoListItemCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SystemInfoListItemCode id = systemInfoListItemCodeArray[n2];
            if (id.getCode().equals(item.getCode())) {
                throw new CodeAlreadyExistsException(item.getCode(), id.getCode(), CustomField.class);
            }
            ++n2;
        }
    }

    public String getCode() {
        return this.code;
    }
}

