/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.event;

import java.lang.reflect.Method;
import java.util.Objects;
import org.apache.commons.lang3.text.WordUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;
import org.squashtest.tm.domain.event.AbstractRequirementEventPublisher;
import org.squashtest.tm.domain.event.RequirementLargePropertyChange;
import org.squashtest.tm.domain.event.RequirementPropertyChange;
import org.squashtest.tm.domain.requirement.RequirementVersion;

@Aspect
public class RequirementModificationEventPublisherAspect
extends AbstractRequirementEventPublisher {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequirementModificationEventPublisherAspect.class);
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ RequirementModificationEventPublisherAspect ajc$perSingletonInstance;

    static {
        try {
            RequirementModificationEventPublisherAspect.ajc$perSingletonInstance = new RequirementModificationEventPublisherAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Pointcut(value="execution(public void org.squashtest.tm.domain.requirement.RequirementVersion.setDescription(*))")
    private /* synthetic */ void executeLargePropertySetter() {
    }

    @Pointcut(value="execution(public void org.squashtest.tm.domain.requirement.RequirementVersion.set*(*)) && !executeLargePropertySetter()")
    private /* synthetic */ void executeSimplePropertySetter() {
    }

    @Around(value="executeSimplePropertySetter() && target(req) && args(newValue)")
    public void listenRequirementModification(ProceedingJoinPoint joinPoint, RequirementVersion req, Object newValue) throws Throwable {
        if (this.eventsAreEnabled(req)) {
            String propertyName = this.extractModifiedPropertyName((JoinPoint)joinPoint);
            Object oldValue = this.readOldValue(req, propertyName);
            joinPoint.proceed(new Object[]{req, newValue});
            if (this.requirementWasModified(oldValue, newValue)) {
                this.raiseSimplePropertyEvent(req, propertyName, oldValue, newValue);
            }
        } else {
            joinPoint.proceed(new Object[]{req, newValue});
        }
    }

    @Around(value="executeLargePropertySetter() && target(req) && args(newValue)")
    public void listenLargeRequirementModification(ProceedingJoinPoint joinPoint, RequirementVersion req, Object newValue) throws Throwable {
        if (this.eventsAreEnabled(req)) {
            String propertyName = this.extractModifiedPropertyName((JoinPoint)joinPoint);
            Object oldValue = this.readOldValue(req, propertyName);
            joinPoint.proceed(new Object[]{req, newValue});
            if (this.requirementWasModified(oldValue, newValue)) {
                this.raiseLargePropertyEvent(req, propertyName, oldValue, newValue);
            }
        } else {
            joinPoint.proceed(new Object[]{req, newValue});
        }
    }

    private boolean requirementWasModified(Object oldValue, Object newValue) {
        return !Objects.equals(Objects.toString(oldValue), Objects.toString(newValue));
    }

    private void raiseSimplePropertyEvent(RequirementVersion req, String propertyName, Object oldValue, Object newValue) {
        RequirementPropertyChange event = RequirementPropertyChange.builder().setSource(req).setModifiedProperty(propertyName).setOldValue(oldValue).setNewValue(newValue).setAuthor(this.currentUser()).build();
        this.publish(event);
        LOGGER.trace("Simple property change event raised");
    }

    private Object readOldValue(RequirementVersion req, String propertyName) {
        try {
            Method propertyGetter = RequirementVersion.class.getMethod("get" + WordUtils.capitalize((String)propertyName), new Class[0]);
            return ReflectionUtils.invokeMethod((Method)propertyGetter, (Object)req);
        }
        catch (NoSuchMethodException e) {
            ReflectionUtils.handleReflectionException((Exception)e);
            return null;
        }
    }

    private String extractModifiedPropertyName(JoinPoint setterJoinPoint) {
        String methodName = setterJoinPoint.getSignature().getName();
        String propertyName = methodName.substring(3);
        return WordUtils.uncapitalize((String)propertyName);
    }

    private void raiseLargePropertyEvent(RequirementVersion req, String propertyName, Object oldValue, Object newValue) {
        RequirementLargePropertyChange event = RequirementLargePropertyChange.builder().setSource(req).setModifiedProperty(propertyName).setOldValue(oldValue).setNewValue(newValue).setAuthor(this.currentUser()).build();
        this.publish(event);
        LOGGER.trace("Large property change event raised");
    }

    private boolean eventsAreEnabled(RequirementVersion req) {
        return this.aspectIsEnabled() && this.requirementIsPersistent(req);
    }

    private boolean requirementIsPersistent(RequirementVersion req) {
        return req.getId() != null;
    }

    public static RequirementModificationEventPublisherAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("org.squashtest.tm.domain.event.RequirementModificationEventPublisherAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

