/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.customreport;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.validation.constraints.NotNull;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.domain.customreport.CustomReportLibrary;
import org.squashtest.tm.domain.report.ReportDefinition;
import org.squashtest.tm.security.annotation.AclConstrainedObject;

@Entity
public class CustomReportReportBinding
implements Identified {
    @Id
    @Column(name="CRRB_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="custom_report_report_binding_crrb_id_seq")
    @SequenceGenerator(name="custom_report_report_binding_crrb_id_seq", sequenceName="custom_report_report_binding_crrb_id_seq", allocationSize=1)
    private Long id;
    @NotNull
    @ManyToOne(cascade={CascadeType.DETACH})
    @JoinColumn(name="CRD_ID", referencedColumnName="CRD_ID")
    private CustomReportDashboard dashboard;
    @ManyToOne
    @JoinColumn(name="REPORT_ID", referencedColumnName="REPORT_ID")
    private ReportDefinition report;
    private int row;
    private int col;
    private int sizeX;
    private int sizeY;

    public CustomReportDashboard getDashboard() {
        return this.dashboard;
    }

    public void setDashboard(CustomReportDashboard dashboard) {
        this.dashboard = dashboard;
    }

    public ReportDefinition getReport() {
        return this.report;
    }

    public void setReport(ReportDefinition report) {
        this.report = report;
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public int getCol() {
        return this.col;
    }

    public void setCol(int col) {
        this.col = col;
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public void setSizeX(int sizeX) {
        this.sizeX = sizeX;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    public void setSizeY(int sizeY) {
        this.sizeY = sizeY;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public boolean hasMoved(CustomReportReportBinding transientBinding) {
        return this.hasMoveRow(transientBinding) || this.hasMoveCol(transientBinding) || this.hasMoveSizeX(transientBinding) || this.hasMoveSizeY(transientBinding);
    }

    public void move(CustomReportReportBinding transientBinding) {
        this.setRow(transientBinding.getRow());
        this.setCol(transientBinding.getCol());
        this.setSizeX(transientBinding.getSizeX());
        this.setSizeY(transientBinding.getSizeY());
    }

    @AclConstrainedObject
    public CustomReportLibrary getCustomReportLibrary() {
        return this.getDashboard().getProject().getCustomReportLibrary();
    }

    private boolean hasMoveSizeX(CustomReportReportBinding transientBinding) {
        return this.getSizeX() != transientBinding.getSizeX();
    }

    private boolean hasMoveSizeY(CustomReportReportBinding transientBinding) {
        return this.getSizeY() != transientBinding.getSizeY();
    }

    private boolean hasMoveCol(CustomReportReportBinding transientBinding) {
        return this.getRow() != transientBinding.getRow();
    }

    private boolean hasMoveRow(CustomReportReportBinding transientBinding) {
        return this.getCol() != transientBinding.getCol();
    }

    public CustomReportReportBinding createCopy() {
        CustomReportReportBinding copy = new CustomReportReportBinding();
        copy.setReport(this.getReport());
        copy.setDashboard(this.getDashboard());
        copy.move(this);
        return copy;
    }
}

