/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.customreport;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.customreport.CustomReportTreeEntity;
import org.squashtest.tm.domain.customreport.CustomReportTreeEntityVisitor;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.tree.GenericTreeLibrary;

@Entity
public class CustomReportLibrary
extends GenericTreeLibrary
implements CustomReportTreeEntity {
    private static final String CLASS_NAME = "org.squashtest.tm.domain.customreport.CustomReportLibrary";
    private static final String SIMPLE_CLASS_NAME = "CustomReportLibrary";
    @Id
    @Column(name="CRL_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="custom_report_library_crl_id_seq")
    @SequenceGenerator(name="custom_report_library_crl_id_seq", sequenceName="custom_report_library_crl_id_seq", allocationSize=1)
    private Long id;
    @OneToOne(mappedBy="customReportLibrary")
    private GenericProject project;

    @Override
    public void notifyAssociatedWithProject(GenericProject p) {
        this.project = p;
    }

    @Override
    public Project getProject() {
        return (Project)this.project;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.project.getName();
    }

    @Override
    public void setName(String name) {
        throw new UnsupportedOperationException("A library cannot be renammed, please rename the project instead");
    }

    @Override
    public void accept(CustomReportTreeEntityVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void setProject(Project project) {
        throw new UnsupportedOperationException("A library shouldn't have his project setted after project creation");
    }

    @Override
    public CustomReportTreeEntity createCopy() {
        throw new UnsupportedOperationException("Cannot copy library, how did you call this method ?");
    }

    @Override
    public EntityReference toEntityReference() {
        return new EntityReference(EntityType.CUSTOM_REPORT_LIBRARY, this.getId());
    }
}

