/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.customreport;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customreport.CustomReportLibrary;
import org.squashtest.tm.domain.customreport.CustomReportTreeEntity;
import org.squashtest.tm.domain.customreport.CustomReportTreeEntityVisitor;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.security.annotation.AclConstrainedObject;

@Entity
public class CustomReportFolder
implements CustomReportTreeEntity,
BoundEntity {
    @Id
    @Column(name="CRF_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="custom_report_folder_crf_id_seq")
    @SequenceGenerator(name="custom_report_folder_crf_id_seq", sequenceName="custom_report_folder_crf_id_seq", allocationSize=1)
    private Long id;
    @NotBlank
    @Size(max=255)
    @Column
    private @NotBlank @Size(max=255) String name;
    @Column
    @Lob
    @Type(type="org.hibernate.type.TextType")
    private String description;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PROJECT_ID")
    private Project project;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void accept(CustomReportTreeEntityVisitor visitor) {
        visitor.visit(this);
    }

    @AclConstrainedObject
    public CustomReportLibrary getCustomReportLibrary() {
        return this.project.getCustomReportLibrary();
    }

    @Override
    public Long getBoundEntityId() {
        return this.getId();
    }

    @Override
    public BindableEntity getBoundEntityType() {
        return BindableEntity.CUSTOM_REPORT_FOLDER;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public void setProject(Project project) {
        this.project = project;
    }

    @Override
    public CustomReportTreeEntity createCopy() {
        CustomReportFolder copy = new CustomReportFolder();
        copy.setName(this.getName());
        copy.setDescription(this.getDescription());
        copy.setProject(this.getProject());
        return copy;
    }
}

