/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.chart;

import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.query.DataType;
import org.squashtest.tm.domain.query.Operation;
import org.squashtest.tm.domain.query.QueryColumnPrototype;
import org.squashtest.tm.domain.query.QueryColumnPrototypeInstance;
import org.squashtest.tm.domain.query.SpecializedEntityType;

@Embeddable
@Table(name="CHART_MEASURE_COLUMN")
public class MeasureColumn
implements QueryColumnPrototypeInstance {
    @JoinColumn(name="CHART_COLUMN_ID")
    @ManyToOne
    private QueryColumnPrototype column;
    @NotBlank
    @Size(min=0, max=30)
    private @NotBlank @Size(min=0, max=30) String label;
    @Enumerated(value=EnumType.STRING)
    @Column(name="MEASURE_OPERATION")
    private Operation operation;
    private Long cufId;

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public EntityType getEntityType() {
        return this.column.getEntityType();
    }

    @Override
    public Long getCufId() {
        return this.cufId;
    }

    public void setCufId(Long cufId) {
        this.cufId = cufId;
    }

    @Override
    public QueryColumnPrototype getColumn() {
        return this.column;
    }

    public void setColumn(QueryColumnPrototype column) {
        this.column = column;
    }

    @Override
    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    @Override
    public SpecializedEntityType getSpecializedType() {
        return this.column.getSpecializedType();
    }

    @Override
    public DataType getDataType() {
        return this.column.getDataType();
    }

    public MeasureColumn createCopy() {
        MeasureColumn copy = new MeasureColumn();
        copy.setColumn(this.getColumn());
        copy.setOperation(this.getOperation());
        copy.setCufId(this.getCufId());
        copy.setLabel(this.getLabel());
        return copy;
    }
}

