/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.chart;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.audit.Auditable;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.audit.AuditableMixinAspect;
import org.squashtest.tm.domain.audit.AuditableSupport;
import org.squashtest.tm.domain.chart.AxisColumn;
import org.squashtest.tm.domain.chart.ChartType;
import org.squashtest.tm.domain.chart.Filter;
import org.squashtest.tm.domain.chart.MeasureColumn;
import org.squashtest.tm.domain.chart.ScopeType;
import org.squashtest.tm.domain.chart.Visibility;
import org.squashtest.tm.domain.customreport.CustomReportChartBinding;
import org.squashtest.tm.domain.customreport.CustomReportLibrary;
import org.squashtest.tm.domain.customreport.CustomReportTreeEntity;
import org.squashtest.tm.domain.customreport.CustomReportTreeEntityVisitor;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.query.ColumnRole;
import org.squashtest.tm.domain.query.QueryColumnPrototypeInstance;
import org.squashtest.tm.domain.query.SpecializedEntityType;
import org.squashtest.tm.security.annotation.AclConstrainedObject;

@Entity
@Table(name="CHART_DEFINITION")
@Auditable
public class ChartDefinition
implements CustomReportTreeEntity,
AuditableMixin {
    @Id
    @Column(name="CHART_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="chart_definition_chart_id_seq")
    @SequenceGenerator(name="chart_definition_chart_id_seq", sequenceName="chart_definition_chart_id_seq", allocationSize=1)
    private Long id;
    @NotBlank
    @Size(min=0, max=50)
    private @NotBlank @Size(min=0, max=50) String name;
    @Enumerated(value=EnumType.STRING)
    private Visibility visibility;
    @Enumerated(value=EnumType.STRING)
    @Column(name="CHART_TYPE")
    private ChartType type;
    @Lob
    @Type(type="org.hibernate.type.TextType")
    private String description;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PROJECT_ID")
    private Project project;
    @Enumerated(value=EnumType.STRING)
    private ScopeType scopeType;
    @ElementCollection
    @CollectionTable(name="CHART_SCOPE", joinColumns={@JoinColumn(name="CHART_ID")})
    @AttributeOverrides(value={@AttributeOverride(name="type", column=@Column(name="ENTITY_REFERENCE_TYPE")), @AttributeOverride(name="id", column=@Column(name="ENTITY_REFERENCE_ID"))})
    private List<EntityReference> scope;
    @ElementCollection
    @CollectionTable(name="CHART_PROJECT_SCOPE", joinColumns={@JoinColumn(name="CHART_ID")})
    private List<String> projectScope;
    @NotNull
    @OneToMany(fetch=FetchType.LAZY, mappedBy="chart", cascade={CascadeType.REMOVE, CascadeType.REFRESH, CascadeType.MERGE, CascadeType.DETACH})
    private Set<CustomReportChartBinding> chartBindings;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="CHART_DEFINITION_ID")
    private List<Filter> filters;
    @ElementCollection
    @CollectionTable(name="CHART_AXIS_COLUMN", joinColumns={@JoinColumn(name="CHART_DEFINITION_ID")})
    @OrderColumn(name="AXIS_RANK")
    private List<AxisColumn> axis;
    @ElementCollection
    @CollectionTable(name="CHART_MEASURE_COLUMN", joinColumns={@JoinColumn(name="CHART_DEFINITION_ID")})
    @OrderColumn(name="MEASURE_RANK")
    private List<MeasureColumn> measures;
    @Transient
    public AuditableSupport audit;

    public ChartDefinition() {
        AuditableMixinAspect.ajc$interFieldInit$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$audit(this);
        this.scope = new ArrayList<EntityReference>();
        this.projectScope = new ArrayList<String>();
        this.chartBindings = new HashSet<CustomReportChartBinding>();
        this.filters = new ArrayList<Filter>();
        this.axis = new ArrayList<AxisColumn>();
        this.measures = new ArrayList<MeasureColumn>();
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public ChartType getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public List<EntityReference> getScope() {
        return this.scope;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public List<AxisColumn> getAxis() {
        return this.axis;
    }

    public List<MeasureColumn> getMeasures() {
        return this.measures;
    }

    public ScopeType getScopeType() {
        return this.scopeType;
    }

    public void setScopeType(ScopeType scopeType) {
        this.scopeType = scopeType;
    }

    public Map<ColumnRole, Set<SpecializedEntityType>> getInvolvedEntities() {
        HashMap<ColumnRole, Set<SpecializedEntityType>> result = new HashMap<ColumnRole, Set<SpecializedEntityType>>(3);
        List<QueryColumnPrototypeInstance> columns = this.getFilters();
        if (!columns.isEmpty()) {
            Set<SpecializedEntityType> filterTypes = this.collectTypes(columns);
            result.put(ColumnRole.FILTER, filterTypes);
        }
        if (!(columns = this.getAxis()).isEmpty()) {
            Set<SpecializedEntityType> axisTypes = this.collectTypes(columns);
            result.put(ColumnRole.AXIS, axisTypes);
        }
        if (!(columns = this.getMeasures()).isEmpty()) {
            Set<SpecializedEntityType> measureTypes = this.collectTypes(columns);
            result.put(ColumnRole.MEASURE, measureTypes);
        }
        return result;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void accept(CustomReportTreeEntityVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public void setProject(Project project) {
        this.project = project;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public void setType(ChartType type) {
        this.type = type;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setScope(List<EntityReference> scope) {
        this.scope = scope;
    }

    @Override
    public CustomReportTreeEntity createCopy() {
        ChartDefinition copy = new ChartDefinition();
        copy.setName(this.getName());
        copy.setProject(this.getProject());
        copy.setProjectScope(this.copyProjectScope());
        copy.setDescription(this.getDescription());
        copy.setType(this.getType());
        copy.setScope(this.copyScope());
        copy.setVisibility(this.getVisibility());
        copy.setScopeType(this.getScopeType());
        copy.setAxis(this.copyAxis());
        copy.setFilters(this.copyFilters());
        copy.setMeasures(this.copyMeasures());
        return copy;
    }

    private List<EntityReference> copyScope() {
        ArrayList<EntityReference> copy = new ArrayList<EntityReference>();
        copy.addAll(this.getScope());
        return copy;
    }

    private List<String> copyProjectScope() {
        ArrayList<String> copy = new ArrayList<String>();
        copy.addAll(this.getProjectScope());
        return copy;
    }

    @AclConstrainedObject
    public CustomReportLibrary getCustomReportLibrary() {
        return this.getProject().getCustomReportLibrary();
    }

    public List<String> getProjectScope() {
        return this.projectScope;
    }

    public void setProjectScope(List<String> projectScope) {
        this.projectScope = projectScope;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    public void setAxis(List<AxisColumn> axis) {
        this.axis = axis;
    }

    public void setMeasures(List<MeasureColumn> measures) {
        this.measures = measures;
    }

    private Set<SpecializedEntityType> collectTypes(Collection<? extends QueryColumnPrototypeInstance> columns) {
        HashSet<SpecializedEntityType> types = new HashSet<SpecializedEntityType>();
        for (QueryColumnPrototypeInstance queryColumnPrototypeInstance : columns) {
            types.add(queryColumnPrototypeInstance.getSpecializedType());
        }
        return types;
    }

    private List<AxisColumn> copyAxis() {
        return this.axis.stream().map(AxisColumn::createCopy).collect(Collectors.toList());
    }

    private List<MeasureColumn> copyMeasures() {
        return this.measures.stream().map(MeasureColumn::createCopy).collect(Collectors.toList());
    }

    private List<Filter> copyFilters() {
        return this.filters.stream().map(Filter::createCopy).collect(Collectors.toList());
    }

    @Override
    public /* synthetic */ AuditableSupport ajc$interFieldGet$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$audit() {
        return this.audit;
    }

    @Override
    public /* synthetic */ void ajc$interFieldSet$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$audit(AuditableSupport auditableSupport) {
        this.audit = auditableSupport;
    }

    @Override
    @Embedded
    @Access(value=AccessType.PROPERTY)
    public AuditableSupport getAudit() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getAudit(this);
    }

    @Override
    public String getCreatedBy() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getCreatedBy(this);
    }

    @Override
    public Date getCreatedOn() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getCreatedOn(this);
    }

    @Override
    public String getLastModifiedBy() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getLastModifiedBy(this);
    }

    @Override
    public Date getLastModifiedOn() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$getLastModifiedOn(this);
    }

    @Override
    public boolean isSkipModifyAudit() {
        return AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$isSkipModifyAudit(this);
    }

    @Override
    public void setAudit(AuditableSupport auditableSupport) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setAudit(this, auditableSupport);
    }

    @Override
    public void setCreatedBy(String string) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setCreatedBy(this, string);
    }

    @Override
    public void setCreatedOn(Date date) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setCreatedOn(this, date);
    }

    @Override
    public void setLastModifiedBy(String string) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setLastModifiedBy(this, string);
    }

    @Override
    public void setLastModifiedOn(Date date) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setLastModifiedOn(this, date);
    }

    @Override
    public void setSkipModifyAudit(boolean bl) {
        AuditableMixinAspect.ajc$interMethod$org_squashtest_tm_domain_audit_AuditableMixinAspect$org_squashtest_tm_domain_audit_AuditableMixin$setSkipModifyAudit(this, bl);
    }
}

