/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.campaign;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;

final class CascadingAutoDateComparatorBuilder {
    private CascadingAutoDateComparatorBuilder() {
    }

    public static Comparator<IterationTestPlanItem> buildTestPlanFirstDateSorter() {
        return new Comparator<IterationTestPlanItem>(){
            private final NullSafeLowerDateComparator comparator = new NullSafeLowerDateComparator();

            @Override
            public int compare(IterationTestPlanItem o1, IterationTestPlanItem o2) {
                Date d1 = o1.getLastExecutedOn();
                Date d2 = o2.getLastExecutedOn();
                return this.comparator.compare(d1, d2);
            }
        };
    }

    public static Comparator<IterationTestPlanItem> buildTestPlanLastDateSorter() {
        return new Comparator<IterationTestPlanItem>(){
            private final NullSafeHigherDateComparator comparator = new NullSafeHigherDateComparator();

            @Override
            public int compare(IterationTestPlanItem o1, IterationTestPlanItem o2) {
                Date d1 = o1.getLastExecutedOn();
                Date d2 = o2.getLastExecutedOn();
                return this.comparator.compare(d1, d2);
            }
        };
    }

    public static Comparator<Iteration> buildIterationActualStartOrder() {
        return new Comparator<Iteration>(){
            private final NullSafeLowerDateComparator comparator = new NullSafeLowerDateComparator();

            @Override
            public int compare(Iteration o1, Iteration o2) {
                Date d1 = o1.getActualStartDate();
                Date d2 = o2.getActualStartDate();
                return this.comparator.compare(d1, d2);
            }
        };
    }

    public static Comparator<Iteration> buildIterationActualEndOrder() {
        return new Comparator<Iteration>(){
            private final NullSafeHigherDateComparator comparator = new NullSafeHigherDateComparator();

            @Override
            public int compare(Iteration o1, Iteration o2) {
                Date d1 = o1.getActualEndDate();
                Date d2 = o2.getActualEndDate();
                return this.comparator.compare(d1, d2);
            }
        };
    }

    private static class NullSafeHigherDateComparator
    implements Comparator<Date>,
    Serializable {
        private NullSafeHigherDateComparator() {
        }

        @Override
        public int compare(Date o1, Date o2) {
            int result = o1 == null ? (o2 == null ? 0 : -1) : (o2 == null ? 1 : o1.compareTo(o2));
            return result;
        }
    }

    private static class NullSafeLowerDateComparator
    implements Comparator<Date> {
        private NullSafeLowerDateComparator() {
        }

        @Override
        public int compare(Date o1, Date o2) {
            int result = o1 == null ? (o2 == null ? 0 : 1) : (o2 == null ? -1 : o1.compareTo(o2));
            return result;
        }
    }
}

