/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.campaign;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderColumn;
import javax.persistence.SequenceGenerator;
import org.hibernate.annotations.Where;
import org.squashtest.tm.core.foundation.exception.NullArgumentException;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.campaign.CampaignLibraryPluginBinding;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.library.NodeContainerVisitor;
import org.squashtest.tm.domain.project.GenericLibrary;
import org.squashtest.tm.domain.project.GenericProject;

@Entity
public class CampaignLibrary
extends GenericLibrary<CampaignLibraryNode> {
    private static final String CLASS_NAME = "org.squashtest.tm.domain.campaign.CampaignLibrary";
    private static final String SIMPLE_CLASS_NAME = "CampaignLibrary";
    @Id
    @Column(name="CL_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="campaign_library_cl_id_seq")
    @SequenceGenerator(name="campaign_library_cl_id_seq", sequenceName="campaign_library_cl_id_seq", allocationSize=1)
    private Long id;
    @OneToMany
    @OrderColumn(name="CONTENT_ORDER")
    @JoinTable(name="CAMPAIGN_LIBRARY_CONTENT", joinColumns={@JoinColumn(name="LIBRARY_ID")}, inverseJoinColumns={@JoinColumn(name="CONTENT_ID")})
    private List<CampaignLibraryNode> rootContent = new ArrayList<CampaignLibraryNode>();
    @OneToOne(mappedBy="campaignLibrary")
    private GenericProject project;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="LIBRARY_ID")
    @Where(clause="LIBRARY_TYPE = 'C'")
    private Set<CampaignLibraryPluginBinding> enabledPlugins = new HashSet<CampaignLibraryPluginBinding>(5);
    @ElementCollection
    @Enumerated(value=EnumType.STRING)
    @JoinTable(name="DISABLED_EXECUTION_STATUS", joinColumns={@JoinColumn(name="CL_ID")})
    @Column(name="EXECUTION_STATUS")
    private Set<ExecutionStatus> disabledStatuses = new HashSet<ExecutionStatus>(ExecutionStatus.DEFAULT_DISABLED_STATUSES);

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public List<CampaignLibraryNode> getRootContent() {
        return this.rootContent;
    }

    @Override
    public List<CampaignLibraryNode> getContent() {
        return this.getRootContent();
    }

    @Override
    public void removeContent(CampaignLibraryNode node) {
        if (node == null) {
            throw new NullArgumentException("CampaignLibrary : cannot remove null node");
        }
        this.rootContent.remove(node);
        this.rootContent = new ArrayList<CampaignLibraryNode>(this.rootContent);
    }

    @Override
    public GenericProject getProject() {
        return this.project;
    }

    @Override
    public void notifyAssociatedWithProject(GenericProject p) {
        this.project = p;
    }

    public Set<ExecutionStatus> getDisabledStatuses() {
        return this.disabledStatuses;
    }

    public void setDisabledStatuses(Set<ExecutionStatus> disabledStatuses) {
        this.disabledStatuses = disabledStatuses;
    }

    public void enableStatus(ExecutionStatus executionStatus) {
        if (executionStatus.canBeDisabled()) {
            this.disabledStatuses.remove(executionStatus);
        }
    }

    public void disableStatus(ExecutionStatus executionStatus) {
        if (executionStatus.canBeDisabled()) {
            this.disabledStatuses.add(executionStatus);
        }
    }

    public boolean allowsStatus(ExecutionStatus executionStatus) {
        return !this.disabledStatuses.contains(executionStatus);
    }

    @Override
    public Set<String> getEnabledPlugins() {
        HashSet<String> pluginIds = new HashSet<String>(this.enabledPlugins.size());
        for (CampaignLibraryPluginBinding binding : this.enabledPlugins) {
            pluginIds.add(binding.getPluginId());
        }
        return pluginIds;
    }

    public Set<CampaignLibraryPluginBinding> getAllPluginBindings() {
        return this.enabledPlugins;
    }

    @Override
    public void enablePlugin(String pluginId) {
        if (!this.isPluginEnabled(pluginId)) {
            CampaignLibraryPluginBinding newBinding = new CampaignLibraryPluginBinding(pluginId);
            this.enabledPlugins.add(newBinding);
        }
    }

    @Override
    public void disablePlugin(String pluginId) {
        CampaignLibraryPluginBinding binding = this.getPluginBinding(pluginId);
        if (binding != null) {
            this.enabledPlugins.remove(binding);
        }
    }

    public CampaignLibraryPluginBinding getPluginBinding(String pluginId) {
        for (CampaignLibraryPluginBinding binding : this.enabledPlugins) {
            if (!binding.getPluginId().equals(pluginId)) continue;
            return binding;
        }
        return null;
    }

    @Override
    public boolean isPluginEnabled(String pluginId) {
        return this.getPluginBinding(pluginId) != null;
    }

    @Override
    public String getClassSimpleName() {
        return SIMPLE_CLASS_NAME;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public boolean hasContent() {
        return !this.rootContent.isEmpty();
    }

    @Override
    public void accept(NodeContainerVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Collection<CampaignLibraryNode> getOrderedContent() {
        return this.rootContent;
    }

    @Override
    public EntityReference toEntityReference() {
        return new EntityReference(EntityType.CAMPAIGN_LIBRARY, this.getId());
    }
}

