/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.bugtracker;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Transient;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.NamedQueries;
import org.hibernate.annotations.NamedQuery;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.bugtracker.IssueList;
import org.squashtest.tm.domain.execution.Execution;

@Entity
@NamedQueries(value={@NamedQuery(name="Issue.findAllForIteration", query="select i from Issue i where i.id in (select ei.id from Iteration it join it.testPlans itp join itp.executions e join e.issueList eil join eil.issues ei where it.id = :id) or i.id in (select esi.id from Iteration it join it.testPlans itp join itp.executions e join e.steps es join es.issueList esil join esil.issues esi where it.id = :id) "), @NamedQuery(name="Issue.findAllForTestSuite", query="select i from Issue i where i.id in (select ei.id from IterationTestPlanItem itp join itp.testSuites ts join itp.executions e join e.issueList eil join eil.issues ei where :id in (select suites.id from itp.testSuites suites)) or id.id in (select esi.id from IterationTestPlanItem itp join itp.testSuites ts join itp.executions e join e.steps es join es.issueList esil join esil.issues esi where :id in (select suites.id from itp.testSuites suites))"), @NamedQuery(name="Issue.findExecution", query="select exec from Execution exec join exec.issueList eil join eil.issues issue where issue.id = :id "), @NamedQuery(name="Issue.findExecutionStep", query="select execStep from ExecutionStep execStep join execStep.issueList esil join esil.issues issue where  issue.id = :id ")})
public class Issue
implements Identified {
    @Id
    @Column(name="ISSUE_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="issue_issue_id_seq")
    @SequenceGenerator(name="issue_issue_id_seq", sequenceName="issue_issue_id_seq", allocationSize=1)
    private Long id;
    @ManyToOne
    @JoinColumn(name="ISSUE_LIST_ID")
    private IssueList issueList;
    @OneToOne(optional=false)
    @ForeignKey(name="FK_Issue_Bugtracker")
    @JoinColumn(name="BUGTRACKER_ID")
    private BugTracker bugtracker;
    @Transient
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinTable(name="EXECUTION_ISSUES_CLOSURE", joinColumns={@JoinColumn(name="ISSUE_ID", insertable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="EXECUTION_ID")})
    private Execution execution;
    private String remoteIssueId;
    private String additionalData;

    @Override
    public Long getId() {
        return this.id;
    }

    public String getRemoteIssueId() {
        return this.remoteIssueId;
    }

    public void setRemoteIssueId(String btId) {
        this.remoteIssueId = btId;
    }

    public IssueList getIssueList() {
        return this.issueList;
    }

    void setIssueList(IssueList issueList) {
        this.issueList = issueList;
    }

    public BugTracker getBugtracker() {
        return this.bugtracker;
    }

    public void setBugtracker(BugTracker bugtracker) {
        this.bugtracker = bugtracker;
    }

    public String getAdditionalData() {
        return this.additionalData;
    }

    public void setAdditionalData(String additionalData) {
        this.additionalData = additionalData;
    }
}

