/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.bugtracker;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.OrderColumn;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.ForeignKey;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.tm.domain.project.GenericProject;

@Entity
@Table(name="BUGTRACKER_BINDING")
public class BugTrackerBinding {
    @Id
    @Column(name="BUGTRACKER_BINDING_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="bugtracker_binding_bugtracker_binding_id_seq")
    @SequenceGenerator(name="bugtracker_binding_bugtracker_binding_id_seq", sequenceName="bugtracker_binding_bugtracker_binding_id_seq", allocationSize=1)
    private Long id;
    @ElementCollection
    @CollectionTable(name="BUGTRACKER_PROJECT", joinColumns={@JoinColumn(name="BUGTRACKER_BINDING_ID")})
    @OrderColumn(name="BUGTRACKER_PROJECT_ORDER")
    private List<String> bugtrackerProjectName = new ArrayList<String>();
    @OneToOne(optional=false)
    @ForeignKey(name="FK_BugtrackerBinding_Bugtracker")
    @JoinColumn(name="BUGTRACKER_ID")
    private BugTracker bugtracker;
    @OneToOne(optional=false)
    @JoinColumn(name="PROJECT_ID")
    private GenericProject project;

    public BugTrackerBinding() {
    }

    public BugTrackerBinding(BugTracker newBugtracker, GenericProject project) {
        this.bugtracker = newBugtracker;
        this.project = project;
    }

    public List<String> getProjectNames() {
        return this.bugtrackerProjectName;
    }

    public void setProjectNames(List<String> projectNames) {
        this.bugtrackerProjectName = projectNames;
    }

    public void addProjectName(String projectName) {
        this.bugtrackerProjectName.add(projectName);
    }

    public BugTracker getBugtracker() {
        return this.bugtracker;
    }

    public void setBugtracker(BugTracker bugtracker) {
        this.bugtracker = bugtracker;
    }

    public Long getId() {
        return this.id;
    }

    public GenericProject getProject() {
        return this.project;
    }

    public void setProject(GenericProject project) {
        this.project = project;
    }
}

