/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.bdd;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.squashtest.tm.domain.bdd.ActionWordParameter;
import org.squashtest.tm.domain.bdd.util.ActionWordUtil;
import org.squashtest.tm.domain.testcase.KeywordTestStep;
import org.squashtest.tm.exception.actionword.InvalidActionWordParameterValueException;

@Entity
@Table(name="ACTION_WORD_PARAMETER_VALUE")
public class ActionWordParameterValue {
    public static final String REGEX_PARAM_VALUE_LINKED_TO_TEST_CASE_PARAM = "<[^\"]+>";
    private static final int ACTION_WORD_PARAM_VALUE_MAX_LENGTH = 255;
    @Id
    @Column(name="ACTION_WORD_PARAMETER_VALUE_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="action_word_parameter_value_action_word_parameter_value_id_seq")
    @SequenceGenerator(name="action_word_parameter_value_action_word_parameter_value_id_seq", sequenceName="action_word_parameter_value_action_word_parameter_value_id_seq", allocationSize=1)
    private Long id;
    @Column(name="VALUE")
    @Size(max=255)
    private @Size(max=255) String value;
    @NotNull
    @ManyToOne(cascade={CascadeType.PERSIST})
    @JoinColumn(name="ACTION_WORD_FRAGMENT_ID")
    private ActionWordParameter actionWordParam;
    @ManyToOne
    @JoinColumn(name="KEYWORD_TEST_STEP_ID")
    private KeywordTestStep keywordTestStep;

    public ActionWordParameterValue() {
    }

    public ActionWordParameterValue(String value) {
        if (value == null) {
            throw new InvalidActionWordParameterValueException("Action word parameter value cannot be null.");
        }
        if (value.contains("\"")) {
            throw new InvalidActionWordParameterValueException("Action word parameter value cannot contain \", < or >.");
        }
        if (value.length() > 255) {
            throw new InvalidActionWordParameterValueException("Action word parameter value length cannot exceed 255 characters.");
        }
        String trimmedValue = value.trim();
        if (trimmedValue.isEmpty()) {
            trimmedValue = "\"\"";
        }
        this.value = ActionWordUtil.replaceExtraSpacesInText(trimmedValue);
    }

    public boolean isLinkedToTestCaseParam() {
        Pattern pattern = Pattern.compile(REGEX_PARAM_VALUE_LINKED_TO_TEST_CASE_PARAM);
        Matcher matcher = pattern.matcher(this.value);
        return matcher.matches();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ActionWordParameter getActionWordParam() {
        return this.actionWordParam;
    }

    public void setActionWordParam(ActionWordParameter actionWordParam) {
        this.actionWordParam = actionWordParam;
    }

    public KeywordTestStep getKeywordTestStep() {
        return this.keywordTestStep;
    }

    public void setKeywordTestStep(KeywordTestStep keywordTestStep) {
        this.keywordTestStep = keywordTestStep;
    }
}

