/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;

public enum Workspace {
    HOME("home"),
    REQUIREMENT("requirement"),
    TEST_CASE("test-case"),
    CAMPAIGN("campaign"),
    CUSTOM_REPORT("custom-report");

    private final String shortName;

    private Workspace(String shortName) {
        this.shortName = shortName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public static Workspace getWorkspaceFromShortName(String shortName) {
        EnumSet<Workspace> workspaces = EnumSet.allOf(Workspace.class);
        for (Workspace workspace : workspaces) {
            if (!workspace.getShortName().equals(shortName)) continue;
            return workspace;
        }
        return null;
    }

    public static boolean isWorkspaceMilestoneFilterable(Workspace workspace) {
        List<Workspace> workspaceMilestoneFilterable = Arrays.asList(TEST_CASE, REQUIREMENT, CAMPAIGN);
        return workspaceMilestoneFilterable.contains((Object)workspace);
    }
}

