/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.actionword.ActionWordLibrary;
import org.squashtest.tm.domain.bdd.ActionWord;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.chart.ChartDefinition;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customreport.CustomReportCustomExport;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.domain.customreport.CustomReportFolder;
import org.squashtest.tm.domain.customreport.CustomReportLibrary;
import org.squashtest.tm.domain.report.ReportDefinition;
import org.squashtest.tm.domain.requirement.HighLevelRequirement;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementLibrary;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestCaseLibrary;
import org.squashtest.tm.domain.testcase.TestStep;

public enum NodeType {
    TEST_CASE_LIBRARY(TestCaseLibrary.class.getSimpleName(), null, null, EntityType.TEST_CASE_LIBRARY),
    TEST_CASE_FOLDER(TestCaseFolder.class.getSimpleName(), BindableEntity.TESTCASE_FOLDER, TEST_CASE_LIBRARY, EntityType.TEST_CASE_FOLDER),
    TEST_CASE(TestCase.class.getSimpleName(), BindableEntity.TEST_CASE, TEST_CASE_LIBRARY, EntityType.TEST_CASE),
    REQUIREMENT_LIBRARY(RequirementLibrary.class.getSimpleName(), null, null, EntityType.REQUIREMENT_LIBRARY),
    REQUIREMENT_FOLDER(RequirementFolder.class.getSimpleName(), BindableEntity.REQUIREMENT_FOLDER, REQUIREMENT_LIBRARY, EntityType.REQUIREMENT_FOLDER),
    REQUIREMENT(Requirement.class.getSimpleName(), BindableEntity.REQUIREMENT_VERSION, REQUIREMENT_LIBRARY, EntityType.REQUIREMENT),
    HIGH_LEVEL_REQUIREMENT(HighLevelRequirement.class.getSimpleName(), BindableEntity.REQUIREMENT_VERSION, REQUIREMENT_LIBRARY, EntityType.HIGH_LEVEL_REQUIREMENT),
    CAMPAIGN_LIBRARY(CampaignLibrary.class.getSimpleName(), null, null, EntityType.CAMPAIGN_LIBRARY),
    CAMPAIGN_FOLDER(CampaignFolder.class.getSimpleName(), BindableEntity.CAMPAIGN_FOLDER, CAMPAIGN_LIBRARY, EntityType.CAMPAIGN_FOLDER),
    CAMPAIGN(Campaign.class.getSimpleName(), BindableEntity.CAMPAIGN, CAMPAIGN_LIBRARY, EntityType.CAMPAIGN),
    ITERATION(Iteration.class.getSimpleName(), BindableEntity.ITERATION, CAMPAIGN_LIBRARY, EntityType.ITERATION),
    TEST_SUITE(TestSuite.class.getSimpleName(), BindableEntity.TEST_SUITE, CAMPAIGN_LIBRARY, EntityType.TEST_SUITE),
    CUSTOM_REPORT_LIBRARY(CustomReportLibrary.class.getSimpleName(), null, null, EntityType.CUSTOM_REPORT_LIBRARY),
    CUSTOM_REPORT_FOLDER(CustomReportFolder.class.getSimpleName(), null, CUSTOM_REPORT_LIBRARY, EntityType.CUSTOM_REPORT_FOLDER),
    CHART_DEFINITION(ChartDefinition.class.getSimpleName(), null, CUSTOM_REPORT_LIBRARY, EntityType.CHART_DEFINITION),
    CUSTOM_REPORT_CUSTOM_EXPORT(CustomReportCustomExport.class.getSimpleName(), null, CUSTOM_REPORT_LIBRARY, EntityType.CUSTOM_REPORT_CUSTOM_EXPORT),
    CUSTOM_REPORT_DASHBOARD(CustomReportDashboard.class.getSimpleName(), null, CUSTOM_REPORT_LIBRARY, EntityType.CUSTOM_REPORT_DASHBOARD),
    REPORT_DEFINITION(ReportDefinition.class.getSimpleName(), null, CUSTOM_REPORT_LIBRARY, EntityType.REPORT_DEFINITION),
    TEST_STEP(TestStep.class.getSimpleName(), BindableEntity.TEST_STEP, TEST_CASE_LIBRARY, EntityType.TEST_STEP),
    ACTION_WORD_LIBRARY(ActionWordLibrary.class.getSimpleName(), null, null, EntityType.ACTION_WORD_LIBRARY),
    ACTION_WORD(ActionWord.class.getSimpleName(), null, ACTION_WORD_LIBRARY, EntityType.ACTION_WORD);

    private String typeName;
    private BindableEntity bindableEntity;
    private NodeType library;
    private EntityType entityType;

    private NodeType(String typeName, BindableEntity bindableEntity, NodeType library, EntityType entityType) {
        this.typeName = typeName;
        this.bindableEntity = bindableEntity;
        this.library = library;
        this.entityType = entityType;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public BindableEntity getBindableEntity() {
        return this.bindableEntity;
    }

    public boolean isCufHolder() {
        return Objects.nonNull((Object)this.bindableEntity);
    }

    public static NodeType fromTypeName(String typeName) {
        if (StringUtils.isBlank((CharSequence)typeName)) {
            throw new IllegalArgumentException("TypeName can't be empty");
        }
        EnumSet<NodeType> entityTypes = EnumSet.allOf(NodeType.class);
        Optional<NodeType> type = entityTypes.stream().filter(entityType -> entityType.getTypeName().equals(typeName)).findFirst();
        if (type.isPresent()) {
            return type.get();
        }
        throw new IllegalArgumentException("No Node Type for type name : " + typeName);
    }

    public NodeType getLibraryType() {
        return this.library;
    }

    public boolean isLibrary() {
        return Objects.isNull((Object)this.library);
    }

    public EntityType toEntityType() {
        return this.entityType;
    }
}

