/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.validation.validator;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.lang.reflect.Field;
import java.util.Collection;
import org.springframework.util.ReflectionUtils;
import org.squashtest.tm.core.foundation.lang.Assert;
import org.squashtest.tm.validation.constraint.HasDefaultItem;

public class HasDefaultItemCollectionValidator
implements ConstraintValidator<HasDefaultItem, Collection<?>> {
    private String prop;

    public void initialize(HasDefaultItem constraintAnnotation) {
        this.prop = constraintAnnotation.value();
        Assert.propertyNotBlank((String)"prop", (String)"HasDefaultItem.value should not be a blank String");
    }

    public boolean isValid(Collection<?> values, ConstraintValidatorContext context) {
        boolean hasDefault = false;
        for (Object item : values) {
            Field f = this.findField(item);
            Boolean val = this.readField(f, item);
            if (!Boolean.TRUE.equals(val)) continue;
            if (hasDefault) {
                return false;
            }
            hasDefault = true;
        }
        return hasDefault;
    }

    private Boolean readField(Field f, Object item) throws IllegalArgumentException {
        Boolean val;
        try {
            val = (Boolean)f.get(item);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        return val;
    }

    private Field findField(Object item) throws IllegalArgumentException, SecurityException {
        Class<?> c = item.getClass();
        Field f = ReflectionUtils.findField(c, (String)this.prop, Boolean.TYPE);
        Field field = f = f != null ? f : ReflectionUtils.findField(c, (String)this.prop, Boolean.class);
        if (f == null) {
            throw new IllegalArgumentException("Item of type " + String.valueOf(c) + " does not have any " + this.prop + " field");
        }
        f.setAccessible(true);
        return f;
    }
}

