/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.jooq.domain.tables;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Index;
import org.jooq.InverseForeignKey;
import org.jooq.Name;
import org.jooq.Path;
import org.jooq.PlainSQL;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.SQL;
import org.jooq.Schema;
import org.jooq.Select;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableOptions;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.TableImpl;
import org.squashtest.tm.jooq.domain.Indexes;
import org.squashtest.tm.jooq.domain.Keys;
import org.squashtest.tm.jooq.domain.Public;
import org.squashtest.tm.jooq.domain.tables.Bugtracker;
import org.squashtest.tm.jooq.domain.tables.IssueList;
import org.squashtest.tm.jooq.domain.tables.records.IssueRecord;

public class Issue
extends TableImpl<IssueRecord> {
    private static final long serialVersionUID = 1L;
    public static final Issue ISSUE = new Issue();
    public final TableField<IssueRecord, Long> ISSUE_ID = Issue.createField((Name)DSL.name((String)"ISSUE_ID"), (DataType)SQLDataType.BIGINT.nullable(false).defaultValue(DSL.field((SQL)DSL.raw((String)"NEXT VALUE FOR \"PUBLIC\".\"ISSUE_ISSUE_ID_SEQ\""), (DataType)SQLDataType.BIGINT)), (Table)this, (String)"");
    public final TableField<IssueRecord, String> REMOTE_ISSUE_ID = Issue.createField((Name)DSL.name((String)"REMOTE_ISSUE_ID"), (DataType)SQLDataType.VARCHAR((int)255).nullable(false), (Table)this, (String)"considering the different types    a bugtracker may use for its own primary keys, we use here a varchar type as it is generic enough");
    public final TableField<IssueRecord, Long> ISSUE_LIST_ID = Issue.createField((Name)DSL.name((String)"ISSUE_LIST_ID"), (DataType)SQLDataType.BIGINT.nullable(false), (Table)this, (String)"References the list of issue to which an issue belongs");
    public final TableField<IssueRecord, Long> BUGTRACKER_ID = Issue.createField((Name)DSL.name((String)"BUGTRACKER_ID"), (DataType)SQLDataType.BIGINT.nullable(false), (Table)this, (String)"Issue's bugtracker");
    public final TableField<IssueRecord, String> ADDITIONAL_DATA = Issue.createField((Name)DSL.name((String)"ADDITIONAL_DATA"), (DataType)SQLDataType.CLOB, (Table)this, (String)"Column for json info. Use it only when remote_key is not enough to fetch issue");
    private transient Bugtracker.BugtrackerPath _bugtracker;
    private transient IssueList.IssueListPath _issueList;

    public Class<IssueRecord> getRecordType() {
        return IssueRecord.class;
    }

    private Issue(Name alias, Table<IssueRecord> aliased) {
        this(alias, aliased, null, null);
    }

    private Issue(Name alias, Table<IssueRecord> aliased, Field<?>[] parameters, Condition where) {
        super(alias, null, aliased, parameters, DSL.comment((String)""), TableOptions.table(), where);
    }

    public Issue(String alias) {
        this(DSL.name((String)alias), (Table<IssueRecord>)ISSUE);
    }

    public Issue(Name alias) {
        this(alias, (Table<IssueRecord>)ISSUE);
    }

    public Issue() {
        this(DSL.name((String)"ISSUE"), null);
    }

    public <O extends Record> Issue(Table<O> path, ForeignKey<O, IssueRecord> childPath, InverseForeignKey<O, IssueRecord> parentPath) {
        super(path, childPath, parentPath, (Table)ISSUE);
    }

    public Schema getSchema() {
        return this.aliased() ? null : Public.PUBLIC;
    }

    public List<Index> getIndexes() {
        return Arrays.asList(Indexes.IDX_ISSUE, Indexes.ISSUE_REMOTE_ISSUE_ID_IDX);
    }

    public UniqueKey<IssueRecord> getPrimaryKey() {
        return Keys.PK_ISSUE;
    }

    public List<ForeignKey<IssueRecord, ?>> getReferences() {
        return Arrays.asList(Keys.FK_ISSUE_BUGTRACKER, Keys.FK_ISSUE_ISSUE_LIST);
    }

    public Bugtracker.BugtrackerPath bugtracker() {
        if (this._bugtracker == null) {
            this._bugtracker = new Bugtracker.BugtrackerPath(this, Keys.FK_ISSUE_BUGTRACKER, null);
        }
        return this._bugtracker;
    }

    public IssueList.IssueListPath issueList() {
        if (this._issueList == null) {
            this._issueList = new IssueList.IssueListPath(this, Keys.FK_ISSUE_ISSUE_LIST, null);
        }
        return this._issueList;
    }

    public Issue as(String alias) {
        return new Issue(DSL.name((String)alias), (Table<IssueRecord>)this);
    }

    public Issue as(Name alias) {
        return new Issue(alias, (Table<IssueRecord>)this);
    }

    public Issue as(Table<?> alias) {
        return new Issue(alias.getQualifiedName(), (Table<IssueRecord>)this);
    }

    public Issue rename(String name) {
        return new Issue(DSL.name((String)name), null);
    }

    public Issue rename(Name name) {
        return new Issue(name, null);
    }

    public Issue rename(Table<?> name) {
        return new Issue(name.getQualifiedName(), null);
    }

    public Issue where(Condition condition) {
        return new Issue(this.getQualifiedName(), (Table<IssueRecord>)(this.aliased() ? this : null), null, condition);
    }

    public Issue where(Collection<? extends Condition> conditions) {
        return this.where(DSL.and(conditions));
    }

    public Issue where(Condition ... conditions) {
        return this.where(DSL.and((Condition[])conditions));
    }

    public Issue where(Field<Boolean> condition) {
        return this.where(DSL.condition(condition));
    }

    @PlainSQL
    public Issue where(SQL condition) {
        return this.where(DSL.condition((SQL)condition));
    }

    @PlainSQL
    public Issue where(String condition) {
        return this.where(DSL.condition((String)condition));
    }

    @PlainSQL
    public Issue where(String condition, Object ... binds) {
        return this.where(DSL.condition((String)condition, (Object[])binds));
    }

    @PlainSQL
    public Issue where(String condition, QueryPart ... parts) {
        return this.where(DSL.condition((String)condition, (QueryPart[])parts));
    }

    public Issue whereExists(Select<?> select) {
        return this.where(DSL.exists(select));
    }

    public Issue whereNotExists(Select<?> select) {
        return this.where(DSL.notExists(select));
    }

    public static class IssuePath
    extends Issue
    implements Path<IssueRecord> {
        private static final long serialVersionUID = 1L;

        public <O extends Record> IssuePath(Table<O> path, ForeignKey<O, IssueRecord> childPath, InverseForeignKey<O, IssueRecord> parentPath) {
            super(path, childPath, parentPath);
        }

        private IssuePath(Name alias, Table<IssueRecord> aliased) {
            super(alias, aliased);
        }

        @Override
        public IssuePath as(String alias) {
            return new IssuePath(DSL.name((String)alias), (Table<IssueRecord>)this);
        }

        @Override
        public IssuePath as(Name alias) {
            return new IssuePath(alias, (Table<IssueRecord>)this);
        }

        @Override
        public IssuePath as(Table<?> alias) {
            return new IssuePath(alias.getQualifiedName(), (Table<IssueRecord>)this);
        }
    }
}

