/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.infrastructure.jooq;

import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.jooq.Binding;
import org.jooq.BindingGetResultSetContext;
import org.jooq.BindingGetSQLInputContext;
import org.jooq.BindingGetStatementContext;
import org.jooq.BindingRegisterContext;
import org.jooq.BindingSQLContext;
import org.jooq.BindingSetSQLOutputContext;
import org.jooq.BindingSetStatementContext;
import org.jooq.Converter;
import org.jooq.Converters;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.ResourceManagingScope;
import org.jooq.conf.ParamType;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.tools.jdbc.JDBCUtils;

public class CustomBlobBinding
implements Binding<byte[], byte[]> {
    private static final long serialVersionUID = 764209784497024714L;

    public Converter<byte[], byte[]> converter() {
        return Converters.identity(byte[].class);
    }

    public final void sql(BindingSQLContext<byte[]> ctx) throws SQLException {
        if (ctx.render().paramType() == ParamType.INLINED) {
            ctx.render().visit((Field)DSL.inline((Object)ctx.convert(this.converter()).value(), (DataType)SQLDataType.BLOB));
        } else {
            ctx.render().sql(ctx.variable());
        }
    }

    public final void register(BindingRegisterContext<byte[]> ctx) throws SQLException {
        ctx.statement().registerOutParameter(ctx.index(), SQLDataType.BLOB.getSQLType());
    }

    public final void set(BindingSetStatementContext<byte[]> ctx) throws SQLException {
        Blob blob = CustomBlobBinding.newBlob(ctx, (byte[])ctx.value(), ctx.statement().getConnection());
        ctx.statement().setBlob(ctx.index(), blob);
    }

    public final void set(BindingSetSQLOutputContext<byte[]> ctx) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public final void get(BindingGetResultSetContext<byte[]> ctx) throws SQLException {
        Blob blob = ctx.resultSet().getBlob(ctx.index());
        ctx.value((Object)(blob == null ? null : CustomBlobBinding.readBlob(blob)));
    }

    public final void get(BindingGetStatementContext<byte[]> ctx) throws SQLException {
        Blob blob = ctx.statement().getBlob(ctx.index());
        ctx.value((Object)(blob == null ? null : CustomBlobBinding.readBlob(blob)));
    }

    public final void get(BindingGetSQLInputContext<byte[]> ctx) throws SQLException {
        Blob blob = ctx.input().readBlob();
        ctx.value((Object)(blob == null ? null : CustomBlobBinding.readBlob(blob)));
    }

    private static byte[] readBlob(Blob blob) throws SQLException {
        try {
            byte[] byArray = blob.getBytes(1L, (int)blob.length());
            return byArray;
        }
        finally {
            JDBCUtils.safeFree((Blob)blob);
        }
    }

    private static Blob newBlob(ResourceManagingScope scope, byte[] bytes, Connection connection) throws SQLException {
        if (bytes == null) {
            return null;
        }
        Blob blob = connection.createBlob();
        scope.autoFree(blob);
        blob.setBytes(1L, bytes);
        return blob;
    }
}

