/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.infrastructure.hibernate;

import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.JoinedSubclassEntityPersister;

public class TestStepPersister
extends JoinedSubclassEntityPersister {
    private static final String NONFORMATTED_TABLE_NAME = "TEST_CASE_STEPS";
    private static final String NONFORMATTED_COLUMN_NAME = "STEP_ID";
    private String formattedTableName;
    private String[] formattedColumnName = new String[1];
    private int cachedIndex = -1;

    public TestStepPersister(PersistentClass persistentClass, EntityDataAccess cacheAccessStrategy, NaturalIdDataAccess naturalIdRegionAccessStrategy, RuntimeModelCreationContext creationContext) throws HibernateException {
        super(persistentClass, cacheAccessStrategy, naturalIdRegionAccessStrategy, creationContext);
        this.init(persistentClass, creationContext.getSessionFactory());
    }

    protected String[] getSubclassTableKeyColumns(int j) {
        if (this.isTheJoinTable(j)) {
            return this.formattedColumnName;
        }
        return super.getSubclassTableKeyColumns(j);
    }

    public boolean isInverseTable(int j) {
        if (this.isTheJoinTable(j)) {
            return true;
        }
        return super.isInverseTable(j);
    }

    private boolean isTheJoinTable(int index) {
        if (this.cachedIndex == -1) {
            boolean isTheOne = this.getSubclassTableName(index).equals(this.formattedTableName);
            if (isTheOne) {
                this.cachedIndex = index;
            }
            return isTheOne;
        }
        return this.cachedIndex == index;
    }

    private void init(PersistentClass persistentClass, SessionFactoryImplementor factory) {
        this.createTableNamePattern(persistentClass);
        this.createColumnName(factory);
    }

    private void createTableNamePattern(PersistentClass persistentClass) {
        List joins = persistentClass.getJoinClosure();
        for (Join join : joins) {
            Table table = join.getTable();
            if (!table.getName().equalsIgnoreCase(NONFORMATTED_TABLE_NAME)) continue;
            this.formattedTableName = table.getQualifiedTableName().render();
            return;
        }
        throw new IllegalArgumentException("TestStepPersister : could not find the join table TEST_CASE_STEPS");
    }

    private void createColumnName(SessionFactoryImplementor factory) {
        Column column = new Column(NONFORMATTED_COLUMN_NAME);
        this.formattedColumnName[0] = column.getQuotedName(factory.getJdbcServices().getDialect());
    }
}

