/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.exception.xlsimport;

import org.squashtest.tm.core.foundation.exception.ActionException;
import org.squashtest.tm.domain.XlsEntityKind;

public class MaxItemsPerImportExceededException
extends ActionException {
    private static final long serialVersionUID = 4967853448753696589L;
    private final int currentItemsCount;
    private final int maxItemsPerImport;
    private final String i18nKey;

    public MaxItemsPerImportExceededException(XlsEntityKind entityKind, int currentItemsCount, int maxItemsPerImport, String message) {
        super(message);
        this.currentItemsCount = currentItemsCount;
        this.maxItemsPerImport = maxItemsPerImport;
        this.i18nKey = this.getI18nKeyForEntityKind(entityKind);
    }

    private String getI18nKeyForEntityKind(XlsEntityKind entityKind) {
        return switch (entityKind) {
            case XlsEntityKind.TEST_CASES -> "sqtm-core.exception.xls-imports.max-test-cases-per-import-exceeded";
            case XlsEntityKind.TEST_STEPS -> "sqtm-core.exception.xls-imports.max-test-steps-per-import-exceeded";
            case XlsEntityKind.REQUIREMENTS -> "sqtm-core.exception.xls-imports.max-requirements-per-import-exceeded";
            default -> throw new MatchException(null, null);
        };
    }

    public String getI18nKey() {
        return this.i18nKey;
    }

    public Object[] messageArgs() {
        return new Object[]{this.currentItemsCount, this.maxItemsPerImport};
    }
}

