/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.exception.exploratoryexecution;

import org.squashtest.tm.core.foundation.exception.ActionException;
import org.squashtest.tm.domain.execution.ExploratoryExecutionEventType;
import org.squashtest.tm.domain.execution.ExploratoryExecutionRunningState;

public class IllegalExploratoryExecutionStateTransitionException
extends ActionException {
    private static final long serialVersionUID = 3645452561863961358L;
    public final ExploratoryExecutionRunningState currentState;
    public final ExploratoryExecutionEventType eventType;

    public IllegalExploratoryExecutionStateTransitionException(ExploratoryExecutionRunningState currentState, ExploratoryExecutionEventType eventType) {
        super(String.format("Current state %s is incompatible with received event %s.", currentState.name(), eventType.name()));
        this.currentState = currentState;
        this.eventType = eventType;
    }

    public static class AlreadyPaused
    extends IllegalExploratoryExecutionStateTransitionException {
        private static final long serialVersionUID = -6429921089294708059L;

        public AlreadyPaused() {
            super(ExploratoryExecutionRunningState.PAUSED, ExploratoryExecutionEventType.PAUSE);
        }

        public String getI18nKey() {
            return "sqtm-core.campaign-workspace.exploratory-execution.running-error.already-paused";
        }
    }

    public static class AlreadyRunning
    extends IllegalExploratoryExecutionStateTransitionException {
        private static final long serialVersionUID = -3649722181839660993L;

        public AlreadyRunning(ExploratoryExecutionEventType eventType) {
            super(ExploratoryExecutionRunningState.RUNNING, eventType);
        }

        public String getI18nKey() {
            return "sqtm-core.campaign-workspace.exploratory-execution.running-error.already-running";
        }
    }

    public static class AlreadyStopped
    extends IllegalExploratoryExecutionStateTransitionException {
        private static final long serialVersionUID = 4840633979433661638L;

        public AlreadyStopped() {
            super(ExploratoryExecutionRunningState.STOPPED, ExploratoryExecutionEventType.STOP);
        }

        public String getI18nKey() {
            return "sqtm-core.campaign-workspace.exploratory-execution.running-error.already-stopped";
        }
    }
}

