/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.exception;

import java.util.Collections;
import java.util.List;

public class CompositeException
extends RuntimeException {
    private static final long serialVersionUID = 836083547975368038L;
    private final List<?> exceptions;

    public <T extends Exception> CompositeException(List<T> exceptions) {
        super(CompositeException.buildMessage(exceptions));
        this.exceptions = exceptions;
    }

    private static String buildMessage(List<?> exceptions) {
        StringBuilder sb = new StringBuilder("Exceptions with the following messages were thrown : [");
        for (Object ex : exceptions) {
            sb.append('\'').append(((Exception)ex).getMessage()).append("', ");
        }
        sb.append(']');
        return sb.toString();
    }

    public List<?> getExceptions() {
        return Collections.unmodifiableList(this.exceptions);
    }
}

