/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.exception;

import java.util.Collections;
import java.util.List;
import org.squashtest.tm.exception.DomainException;

public class CompositeDomainException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final List<? extends DomainException> exceptions;

    public <T extends Exception> CompositeDomainException(List<? extends DomainException> exceptions) {
        super(CompositeDomainException.buildMessage(exceptions));
        this.exceptions = exceptions;
    }

    private static String buildMessage(List<?> exceptions) {
        StringBuilder sb = new StringBuilder("Exceptions with the following messages were thrown : [");
        for (Object ex : exceptions) {
            sb.append('\'').append(((Exception)ex).getMessage()).append("', ");
        }
        sb.append(']');
        return sb.toString();
    }

    public List<DomainException> getExceptions() {
        return Collections.unmodifiableList(this.exceptions);
    }
}

