/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.users;

import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.NamedQueries;
import org.hibernate.annotations.NamedQuery;
import org.squashtest.tm.domain.audit.Auditable;
import org.squashtest.tm.domain.audit.AuditableSupport;
import org.squashtest.tm.domain.users.Party;
import org.squashtest.tm.domain.users.PartyVisitor;
import org.squashtest.tm.domain.users.User;

@Entity
@Auditable
@Table(name="CORE_TEAM")
@PrimaryKeyJoinColumn(name="PARTY_ID")
@NamedQueries(value={@NamedQuery(name="Team.countAssociatedTeams", query="select count(*) from Team t join t.members m where m.id = ?1"), @NamedQuery(name="Team.findAllNonAssociatedTeams", query="select t from Team t where t.id not in (select ti.id from Team ti join ti.members m where m.id = ?1)")})
public class Team
extends Party {
    private static final String TYPE = "TEAM";
    @NotBlank
    @Size(max=50)
    private @NotBlank @Size(max=50) String name;
    private String description;
    @ManyToMany
    @JoinTable(name="CORE_TEAM_MEMBER", joinColumns={@JoinColumn(name="TEAM_ID")}, inverseJoinColumns={@JoinColumn(name="USER_ID")})
    private final Set<User> members = new HashSet<User>();
    @Embedded
    private AuditableSupport audit = new AuditableSupport();

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.trim();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Set<User> getMembers() {
        return this.members;
    }

    public void addMember(User user) {
        this.members.add(user);
    }

    public void addMembers(Collection<User> users) {
        this.members.addAll(users);
    }

    public void removeMember(User user) {
        this.members.remove(user);
    }

    public void removeMember(Collection<User> users) {
        this.members.removeAll(users);
    }

    @Override
    public Date getCreatedOn() {
        return this.audit.getCreatedOn();
    }

    @Override
    public String getCreatedBy() {
        return this.audit.getCreatedBy();
    }

    @Override
    public Date getLastModifiedOn() {
        return this.audit.getLastModifiedOn();
    }

    @Override
    public String getLastModifiedBy() {
        return this.audit.getLastModifiedBy();
    }

    @Override
    public boolean isSkipModifyAudit() {
        return this.audit.isSkipModifyAudit();
    }

    @Override
    public void setCreatedBy(String createdBy) {
        this.audit.setCreatedBy(createdBy);
    }

    @Override
    public void setCreatedOn(Date createdOn) {
        this.audit.setCreatedOn(createdOn);
    }

    @Override
    public void setLastModifiedBy(String lastModifiedBy) {
        this.audit.setLastModifiedBy(lastModifiedBy);
    }

    @Override
    public void setLastModifiedOn(Date lastModifiedOn) {
        this.audit.setLastModifiedOn(lastModifiedOn);
    }

    @Override
    public void setSkipModifyAudit(boolean skipModifyAudit) {
        this.audit.setSkipModifyAudit(skipModifyAudit);
    }

    @Override
    public void setReadOnlyModifyAudit(String readOnlyLastModifiedBy, Date readOnlyLastModifiedOn) {
        this.audit.setReadOnlyModifyAudit(readOnlyLastModifiedBy, readOnlyLastModifiedOn);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void accept(PartyVisitor visitor) {
        visitor.visit(this);
    }
}

