/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.users;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.Date;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.users.User;

@Entity
@Table(name="API_TOKEN")
public class ApiToken
implements Identified {
    @Id
    @Column(name="TOKEN_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="api_token_token_id_seq")
    @SequenceGenerator(name="api_token_token_id_seq", sequenceName="api_token_token_id_seq", allocationSize=1)
    private Long id;
    @NotNull
    @Pattern(regexp="[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}")
    private @NotNull @Pattern(regexp="[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}") String uuid;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_id")
    private User user;
    @NotNull
    private String name;
    @NotNull
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdOn;
    @NotNull
    @Size(max=100)
    private @NotNull @Size(max=100) String createdBy;
    @NotNull
    @Pattern(regexp="\\d{4}-\\d{2}-\\d{2}", message="Expiry date must be in the format yyyy-mm-dd")
    private @NotNull @Pattern(regexp="\\d{4}-\\d{2}-\\d{2}", message="Expiry date must be in the format yyyy-mm-dd") String expiryDate;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastUsage;
    @NotNull
    private String permissions;

    public ApiToken() {
    }

    public ApiToken(String uuid, User user, String name, Date createdOn, String createdBy, String expiryDate, String permissions) {
        this.uuid = uuid;
        this.user = user;
        this.name = name;
        this.createdOn = createdOn;
        this.createdBy = createdBy;
        this.expiryDate = expiryDate;
        this.permissions = permissions;
    }

    public String getUuid() {
        return this.uuid;
    }

    public User getUser() {
        return this.user;
    }

    public String getName() {
        return this.name;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getExpiryDate() {
        return this.expiryDate;
    }

    public Date getLastUsage() {
        return this.lastUsage;
    }

    public void setLastUsage(Date lastUsage) {
        this.lastUsage = lastUsage;
    }

    public String getPermissions() {
        return this.permissions;
    }

    @Override
    public Long getId() {
        return this.id;
    }
}

