/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.tf.automationrequest;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Date;
import org.hibernate.validator.constraints.URL;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequest;
import org.squashtest.tm.domain.tf.automationrequest.SynchronizableIssueStatus;

@Entity
@Table(name="REMOTE_AUTOMATION_REQUEST_EXTENDER")
public class RemoteAutomationRequestExtender {
    @Id
    @Column(name="REMOTE_AUTOMATION_REQUEST_EXTENDER_ID")
    @SequenceGenerator(name="remote_automation_request_ext_remote_automation_request_ext_seq", sequenceName="remote_automation_request_ext_remote_automation_request_ext_seq", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="remote_automation_request_ext_remote_automation_request_ext_seq")
    private Long id;
    @ManyToOne
    @JoinColumn(name="SERVER_ID", referencedColumnName="BUGTRACKER_ID")
    private BugTracker server;
    @NotNull
    @OneToOne(optional=false)
    @JoinColumn(name="AUTOMATION_REQUEST_ID", referencedColumnName="AUTOMATION_REQUEST_ID")
    private AutomationRequest automationRequest;
    @Column(name="REMOTE_STATUS")
    private String remoteRequestStatus;
    @Column(name="REMOTE_ISSUE_KEY")
    private String remoteIssueKey;
    @Column(name="REMOTE_ASSIGNED_TO")
    private String remoteAssignedTo;
    @URL
    @Size(max=300)
    private @URL @Size(max=300) String remoteRequestUrl;
    @Column(name="LAST_SYNC_DATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastSyncDate;
    @Column(name="LAST_SYNC_DATE_SQUASH")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastSyncDateSquash;
    @Column(name="SENT_VALUE_FOR_SYNC")
    private String sentValueForSync;
    @Enumerated(value=EnumType.STRING)
    @Column(name="SYNCHRONIZABLE_ISSUE_STATUS")
    private SynchronizableIssueStatus synchronizableIssueStatus = SynchronizableIssueStatus.TO_SYNCHRONIZE;

    public SynchronizableIssueStatus getSynchronizableIssueStatus() {
        return this.synchronizableIssueStatus;
    }

    public Date getLastSyncDateSquash() {
        return this.lastSyncDateSquash;
    }

    public void setLastSyncDateSquash(Date lastSyncDateSquash) {
        this.lastSyncDateSquash = lastSyncDateSquash;
    }

    public void setSynchronizableIssueStatus(SynchronizableIssueStatus synchronizableIssueStatus) {
        this.synchronizableIssueStatus = synchronizableIssueStatus;
    }

    public String getRemoteIssueKey() {
        return this.remoteIssueKey;
    }

    public void setRemoteIssueKey(String remoteIssueKey) {
        this.remoteIssueKey = remoteIssueKey;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public BugTracker getServer() {
        return this.server;
    }

    public void setServer(BugTracker server) {
        this.server = server;
    }

    public AutomationRequest getAutomationRequest() {
        return this.automationRequest;
    }

    public void setAutomationRequest(AutomationRequest automationRequest) {
        this.automationRequest = automationRequest;
    }

    public String getRemoteRequestStatus() {
        return this.remoteRequestStatus;
    }

    public void setRemoteRequestStatus(String remoteRequestStatus) {
        this.remoteRequestStatus = remoteRequestStatus;
    }

    public String getRemoteRequestUrl() {
        return this.remoteRequestUrl;
    }

    public void setRemoteRequestUrl(String remoteRequestUrl) {
        this.remoteRequestUrl = remoteRequestUrl;
    }

    public String getRemoteAssignedTo() {
        return this.remoteAssignedTo;
    }

    public void setRemoteAssignedTo(String remoteAssignedTo) {
        this.remoteAssignedTo = remoteAssignedTo;
    }

    public Date getLastSyncDate() {
        return this.lastSyncDate;
    }

    public void setLastSyncDate(Date lastSyncDate) {
        this.lastSyncDate = lastSyncDate;
    }

    public String getSentValueForSync() {
        return this.sentValueForSync;
    }

    public void setSentValueForSync(String sentValueForSync) {
        this.sentValueForSync = sentValueForSync;
    }
}

