/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.tf.automationrequest;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.annotations.BatchSize;
import org.squashtest.tm.domain.AclPrimaryObject;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequest;

@Entity
public class AutomationRequestLibrary
implements AclPrimaryObject {
    public static final String CLASS_NAME = "org.squashtest.tm.domain.tf.automationrequest.AutomationRequestLibrary";
    private static final String SIMPLE_CLASS_NAME = "AutomationRequestLibrary";
    @Id
    @Column(name="ARL_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="automation_request_library_arl_id_seq")
    @SequenceGenerator(name="automation_request_library_arl_id_seq", sequenceName="automation_request_library_arl_id_seq", allocationSize=1)
    private Long id;
    @OneToMany
    @JoinTable(name="AUTOMATION_REQUEST_LIBRARY_CONTENT", joinColumns={@JoinColumn(name="LIBRARY_ID")}, inverseJoinColumns={@JoinColumn(name="CONTENT_ID")})
    @BatchSize(size=10)
    private List<AutomationRequest> rootContent = new ArrayList<AutomationRequest>();
    @OneToOne(mappedBy="automationRequestLibrary")
    private GenericProject project;
    @OneToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE}, fetch=FetchType.LAZY)
    @JoinColumn(name="ATTACHMENT_LIST_ID")
    private final AttachmentList attachmentList = new AttachmentList();

    public void notifyAssociatedWithProject(GenericProject p) {
        this.project = p;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public List<AutomationRequest> getRootContent() {
        return this.rootContent;
    }

    public void setRootContent(List<AutomationRequest> rootContent) {
        this.rootContent = rootContent;
    }

    public GenericProject getProject() {
        return this.project;
    }

    public void setProject(GenericProject project) {
        this.project = project;
    }

    public AttachmentList getAttachmentList() {
        return this.attachmentList;
    }

    public void addContent(AutomationRequest request) {
        this.rootContent.add(request);
    }

    public void removeContent(AutomationRequest request) {
        this.rootContent.remove(request);
    }

    @Override
    public String getClassSimpleName() {
        return SIMPLE_CLASS_NAME;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }
}

