/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.testcase;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.SequenceGenerator;
import java.util.Set;
import org.squashtest.tm.domain.SelfClassAware;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.audit.Auditable;
import org.squashtest.tm.domain.library.GenericLibraryNode;
import org.squashtest.tm.domain.library.Library;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNodeVisitor;
import org.squashtest.tm.security.annotation.AclConstrainedObject;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Auditable
public abstract class TestCaseLibraryNode
extends GenericLibraryNode
implements SelfClassAware {
    @Id
    @Column(name="TCLN_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="test_case_library_node_tcln_id_seq")
    @SequenceGenerator(name="test_case_library_node_tcln_id_seq", sequenceName="test_case_library_node_tcln_id_seq", allocationSize=1)
    private Long id;

    @Override
    public Long getId() {
        return this.id;
    }

    public abstract void accept(TestCaseLibraryNodeVisitor var1);

    @Override
    @AclConstrainedObject
    public Library<?> getLibrary() {
        return this.getProject().getTestCaseLibrary();
    }

    public Set<Attachment> getAllAttachments() {
        return this.getAttachmentList().getAllAttachments();
    }

    @Override
    protected Class<? extends GenericLibraryNode> getGenericNodeClass() {
        return TestCaseLibraryNode.class;
    }
}

